/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.model.jpa;

import com.google.auto.service.AutoService;
import io.phasetwo.keycloak.model.WebhookProvider;
import io.phasetwo.keycloak.model.WebhookProviderFactory;
import io.phasetwo.keycloak.model.jpa.JpaWebhookProvider;
import jakarta.persistence.EntityManager;
import org.keycloak.Config;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

@AutoService(value={WebhookProviderFactory.class})
public class JpaWebhookProviderFactory
implements WebhookProviderFactory {
    public static final String PROVIDER_ID = "jpa-webhook";

    public String getId() {
        return PROVIDER_ID;
    }

    public WebhookProvider create(KeycloakSession session) {
        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        return new JpaWebhookProvider(session, em);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }
}

