/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.model.jpa;

import io.phasetwo.keycloak.model.WebhookModel;
import io.phasetwo.keycloak.model.jpa.entity.WebhookEntity;
import jakarta.persistence.EntityManager;
import java.util.Date;
import java.util.Set;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.JpaModel;

public class WebhookAdapter
implements WebhookModel,
JpaModel<WebhookEntity> {
    protected final KeycloakSession session;
    protected final WebhookEntity webhook;
    protected final EntityManager em;
    protected final RealmModel realm;

    public WebhookAdapter(KeycloakSession session, RealmModel realm, EntityManager em, WebhookEntity webhook) {
        this.session = session;
        this.realm = realm;
        this.em = em;
        this.webhook = webhook;
    }

    public WebhookEntity getEntity() {
        return this.webhook;
    }

    @Override
    public String getId() {
        return this.webhook.getId();
    }

    @Override
    public boolean isEnabled() {
        return this.webhook.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.webhook.setEnabled(enabled);
    }

    @Override
    public String getUrl() {
        return this.webhook.getUrl();
    }

    @Override
    public void setUrl(String url) {
        this.webhook.setUrl(url);
    }

    @Override
    public String getSecret() {
        return this.webhook.getSecret();
    }

    @Override
    public void setSecret(String secret) {
        this.webhook.setSecret(secret);
    }

    @Override
    public String getAlgorithm() {
        return this.webhook.getAlgorithm();
    }

    @Override
    public void setAlgorithm(String algorithm) {
        this.webhook.setAlgorithm(algorithm);
    }

    @Override
    public RealmModel getRealm() {
        return this.session.realms().getRealm(this.webhook.getRealmId());
    }

    @Override
    public UserModel getCreatedBy() {
        return this.session.users().getUserById(this.getRealm(), this.webhook.getCreatedBy());
    }

    @Override
    public Date getCreatedAt() {
        return this.webhook.getCreatedAt();
    }

    @Override
    public Set<String> getEventTypes() {
        return this.webhook.getEventTypes();
    }

    @Override
    public void addEventType(String eventType) {
        this.webhook.getEventTypes().add(eventType);
    }

    @Override
    public void removeEventTypes() {
        this.webhook.getEventTypes().clear();
    }
}

