/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.model.jpa.entity;

import com.google.auto.service.AutoService;
import io.phasetwo.keycloak.model.WebhookProvider;
import io.phasetwo.keycloak.model.jpa.entity.WebhookEntityProvider;
import org.keycloak.Config;
import org.keycloak.connections.jpa.entityprovider.JpaEntityProvider;
import org.keycloak.connections.jpa.entityprovider.JpaEntityProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;

@AutoService(value={JpaEntityProviderFactory.class})
public class WebhookEntityProviderFactory
implements JpaEntityProviderFactory {
    protected static final String ID = "ext-entity-webhook";

    public JpaEntityProvider create(KeycloakSession session) {
        return new WebhookEntityProvider();
    }

    public String getId() {
        return ID;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            if (event instanceof RealmModel.RealmRemovedEvent) {
                this.realmRemoved((RealmModel.RealmRemovedEvent)event);
            }
        });
    }

    public void close() {
    }

    private void realmRemoved(RealmModel.RealmRemovedEvent event) {
        ((WebhookProvider)event.getKeycloakSession().getProvider(WebhookProvider.class)).removeWebhooks(event.getRealm());
    }
}

