/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.representation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.phasetwo.keycloak.representation.ExtendedAuthDetails;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.events.Event;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AuthDetails;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.RealmModel;

public class ExtendedAdminEvent
extends AdminEvent {
    @JsonIgnore
    private ExtendedAuthDetails extAuthDetails;
    private String uid;
    private String type;
    private Map<String, String> details = new HashMap<String, String>();

    private static String createType(AdminEvent event) {
        StringBuilder o = new StringBuilder("admin.");
        if (event.getResourceTypeAsString() != null) {
            o.append(event.getResourceTypeAsString());
        }
        if (event.getResourceTypeAsString() != null && event.getOperationType() != null) {
            o.append("-");
        }
        if (event.getOperationType() != null) {
            o.append(event.getOperationType());
        }
        return o.toString();
    }

    private static String createType(Event event) {
        StringBuilder o = new StringBuilder("access.");
        if (event.getType() != null) {
            o.append(event.getType());
        }
        return o.toString();
    }

    public ExtendedAdminEvent() {
    }

    public ExtendedAdminEvent(String uid, AdminEvent event, RealmModel realm) {
        this.uid = uid;
        this.type = ExtendedAdminEvent.createType(event);
        this.setTime(event.getTime());
        this.setRealmId(realm.getName());
        this.setAuthDetails(event.getAuthDetails());
        this.extAuthDetails.setRealmId(realm.getName());
        this.setResourceType(event.getResourceType());
        this.setResourceTypeAsString(event.getResourceTypeAsString());
        this.setOperationType(event.getOperationType());
        this.setResourcePath(event.getResourcePath());
        this.setRepresentation(event.getRepresentation());
        this.setError(event.getError());
    }

    public ExtendedAdminEvent(String uid, Event event, RealmModel realm) {
        this.uid = uid;
        this.type = ExtendedAdminEvent.createType(event);
        ExtendedAuthDetails authDetails = new ExtendedAuthDetails(null);
        authDetails.setRealmId(realm.getName());
        authDetails.setClientId(event.getClientId());
        authDetails.setIpAddress(event.getIpAddress());
        authDetails.setSessionId(event.getSessionId());
        authDetails.setUserId(event.getUserId());
        this.setAuthDetails(authDetails);
        this.setDetails(event.getDetails());
        this.setError(event.getError());
        this.setRealmId(event.getRealmId());
        this.setTime(event.getTime());
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="details")
    public Map<String, String> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    @JsonProperty(value="authDetails")
    public ExtendedAuthDetails getAuthDetails() {
        return this.extAuthDetails;
    }

    public void setAuthDetails(AuthDetails authDetails) {
        this.extAuthDetails = authDetails == null ? null : (authDetails instanceof ExtendedAuthDetails ? (ExtendedAuthDetails)authDetails : new ExtendedAuthDetails(authDetails));
    }

    @JsonProperty(value="resourceType")
    public String getResourceTypeAsString() {
        return super.getResourceTypeAsString();
    }

    @JsonIgnore
    public ResourceType getResourceType() {
        return super.getResourceType();
    }
}

