/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.resources;

import io.phasetwo.keycloak.events.WebhookSenderEventListenerProvider;
import io.phasetwo.keycloak.representation.ExtendedAdminEvent;
import io.phasetwo.keycloak.representation.ExtendedAuthDetails;
import io.phasetwo.keycloak.resources.AbstractAdminResource;
import jakarta.validation.Valid;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.models.KeycloakSession;

public class EventsResource
extends AbstractAdminResource {
    private static final Logger log = Logger.getLogger(EventsResource.class);

    public EventsResource(KeycloakSession session) {
        super(session);
    }

    @POST
    @Consumes(value={"application/json"})
    public Response publishEvent(@Valid ExtendedAdminEvent body) {
        log.infof("Publish event for %s %s", (Object)this.realm.getName(), (Object)body);
        this.requireAdminRole("publish-events");
        if (body.getType() == null) {
            throw new BadRequestException("Event must contain a type");
        }
        if (body.getType().toLowerCase().startsWith("access.") || body.getType().toLowerCase().startsWith("admin.") || body.getType().toLowerCase().startsWith("system.")) {
            throw new ClientErrorException("Reserved event type.", 409);
        }
        if (body.getTime() < 1L) {
            body.setTime(System.currentTimeMillis());
        }
        body.setAuthDetails(this.getAuthDetails());
        this.getEventEmitter().ifPresent(e -> e.processEvent(body, this.realm.getId()));
        return Response.accepted().type("*/*").build();
    }

    private ExtendedAuthDetails getAuthDetails() {
        ExtendedAuthDetails details = new ExtendedAuthDetails(null);
        details.setRealmId(this.auth.getRealm().getName());
        details.setClientId(this.auth.getClient().getClientId());
        details.setUserId(this.auth.getUser().getId());
        details.setUsername(this.auth.getUser().getUsername());
        EventsResource.optionalOf(() -> this.session.getContext().getConnection().getRemoteAddr()).ifPresent(arg_0 -> ((ExtendedAuthDetails)details).setIpAddress(arg_0));
        EventsResource.optionalOf(() -> this.session.getContext().getAuthenticationSession().getParentSession().getId()).ifPresent(details::setSessionId);
        return details;
    }

    static <T> Optional<T> optionalOf(Supplier<T> supplier) {
        try {
            return Optional.ofNullable(supplier.get());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    private Optional<WebhookSenderEventListenerProvider> getEventEmitter() {
        EventListenerProvider listener = (EventListenerProvider)this.session.getProvider(EventListenerProvider.class, "ext-event-webhook");
        if (listener != null && listener instanceof WebhookSenderEventListenerProvider) {
            return Optional.of((WebhookSenderEventListenerProvider)listener);
        }
        return Optional.empty();
    }
}

