/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.resources;

import com.google.auto.service.AutoService;
import io.phasetwo.keycloak.resources.EventsResourceProvider;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resource.RealmResourceProviderFactory;

@AutoService(value={RealmResourceProviderFactory.class})
public class EventsResourceProviderFactory
implements RealmResourceProviderFactory {
    private static final Logger log = Logger.getLogger(EventsResourceProviderFactory.class);
    public static final String ID = "events";
    public static final String ROLE_PUBLISH_EVENTS = "publish-events";

    public RealmResourceProvider create(KeycloakSession session) {
        return new EventsResourceProvider(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            if (event instanceof RealmModel.RealmPostCreateEvent) {
                this.realmPostCreate((RealmModel.RealmPostCreateEvent)event);
            } else if (event instanceof PostMigrationEvent && System.getenv("KC_ORGS_SKIP_MIGRATION") == null) {
                log.info((Object)"initializing event roles following migration");
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, this::initRoles);
            }
        });
    }

    private void initRoles(KeycloakSession session) {
        RealmManager manager = new RealmManager(session);
        session.realms().getRealmsStream().forEach(realm -> {
            ClientModel client = realm.getMasterAdminClient();
            if (client.getRole(ROLE_PUBLISH_EVENTS) == null) {
                this.addMasterAdminRoles(manager, (RealmModel)realm);
            }
            if (!realm.getName().equals(Config.getAdminRealm()) && (client = realm.getClientByClientId(manager.getRealmAdminClientId(realm))).getRole(ROLE_PUBLISH_EVENTS) == null) {
                this.addRealmAdminRoles(manager, (RealmModel)realm);
            }
        });
    }

    private void realmPostCreate(RealmModel.RealmPostCreateEvent event) {
        RealmModel realm = event.getCreatedRealm();
        RealmManager manager = new RealmManager(event.getKeycloakSession());
        this.addMasterAdminRoles(manager, realm);
        if (!realm.getName().equals(Config.getAdminRealm())) {
            this.addRealmAdminRoles(manager, realm);
        }
    }

    private void addMasterAdminRoles(RealmManager manager, RealmModel realm) {
        RealmModel master = manager.getRealmByName(Config.getAdminRealm());
        RoleModel admin = master.getRole(AdminRoles.ADMIN);
        ClientModel client = realm.getMasterAdminClient();
        this.addRoles(client, admin);
    }

    private void addRealmAdminRoles(RealmManager manager, RealmModel realm) {
        ClientModel client = realm.getClientByClientId(manager.getRealmAdminClientId(realm));
        RoleModel admin = client.getRole(AdminRoles.REALM_ADMIN);
        this.addRoles(client, admin);
    }

    private void addRoles(ClientModel client, RoleModel parent) {
        String[] names;
        for (String name : names = new String[]{ROLE_PUBLISH_EVENTS}) {
            if (client.getRole(name) == null) {
                RoleModel role = client.addRole(name);
                role.setDescription("${role_" + name + "}");
                parent.addCompositeRole(role);
                continue;
            }
            log.infof("Role %s already exists. Skipping...", (Object)name);
        }
    }

    public void close() {
    }

    public String getId() {
        return ID;
    }
}

