/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.resources;

import io.phasetwo.keycloak.representation.RealmAttributeRepresentation;
import io.phasetwo.keycloak.resources.AbstractAdminResource;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;

public class RealmAttributesResource
extends AbstractAdminResource {
    private static final Logger log = Logger.getLogger(RealmAttributesResource.class);

    public RealmAttributesResource(KeycloakSession session) {
        super(session);
    }

    @GET
    @Produces(value={"application/json"})
    public Map<String, RealmAttributeRepresentation> getAttributes() {
        if (!this.permissions.realm().canViewRealm()) {
            throw new ForbiddenException("get attributes requires view-realm");
        }
        return this.realm.getAttributes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            RealmAttributeRepresentation r = new RealmAttributeRepresentation();
            r.setRealm(this.realm.getName());
            r.setName((String)e.getKey());
            r.setValue((String)e.getValue());
            return r;
        }));
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createAttribute(RealmAttributeRepresentation rep) {
        if (!this.permissions.realm().canManageRealm()) {
            throw new ForbiddenException("create attribute requires manage-realm");
        }
        this.validateRealmAttributeRepresentation(rep);
        this.realm.setAttribute(rep.getName(), rep.getValue());
        return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(rep.getName()).build(new Object[0])).build();
    }

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json"})
    public RealmAttributeRepresentation getAttribute(@PathParam(value="key") String key) {
        if (!this.permissions.realm().canViewRealm()) {
            throw new ForbiddenException("get attribute requires view-realm");
        }
        String a = this.realm.getAttribute(key);
        if (a == null) {
            throw new NotFoundException(String.format("attribute %s not present", key));
        }
        RealmAttributeRepresentation r = new RealmAttributeRepresentation();
        r.setRealm(this.realm.getName());
        r.setName(key);
        r.setValue(a);
        return r;
    }

    @PUT
    @Path(value="{key}")
    @Consumes(value={"application/json"})
    public Response updateAttribute(@PathParam(value="key") String key, RealmAttributeRepresentation rep) {
        if (!this.permissions.realm().canManageRealm()) {
            throw new ForbiddenException("update attribute requires manage-realm");
        }
        this.validateRealmAttributeRepresentation(rep);
        if (!rep.getName().equals(key)) {
            throw new BadRequestException("keys must match");
        }
        this.realm.setAttribute(rep.getName(), rep.getValue());
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="{key}")
    public Response removeAttribute(@PathParam(value="key") String key) {
        if (!this.permissions.realm().canManageRealm()) {
            throw new ForbiddenException("remove attribute requires manage-realm");
        }
        this.realm.removeAttribute(key);
        return Response.noContent().build();
    }

    protected void validateRealmAttributeRepresentation(RealmAttributeRepresentation rep) {
        if (rep.getRealm() == null || rep.getName() == null || rep.getValue() == null) {
            throw new BadRequestException("realm, name and value must be valid");
        }
        if (!rep.getRealm().equals(this.realm.getName())) {
            throw new BadRequestException("realm must match");
        }
        if (rep.getName().length() > 255) {
            throw new BadRequestException("key must be < 255 chars");
        }
    }
}

