/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.resources;

import io.phasetwo.keycloak.model.WebhookModel;
import io.phasetwo.keycloak.model.WebhookProvider;
import io.phasetwo.keycloak.representation.WebhookRepresentation;
import io.phasetwo.keycloak.resources.AbstractAdminResource;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserModel;
import org.keycloak.services.resources.admin.AdminRoot;

public class WebhooksResource
extends AbstractAdminResource {
    private static final Logger log = Logger.getLogger(WebhooksResource.class);
    private final WebhookProvider webhooks;

    public WebhooksResource(KeycloakSession session) {
        super(session);
        this.webhooks = (WebhookProvider)session.getProvider(WebhookProvider.class);
    }

    @GET
    @Produces(value={"application/json"})
    public Stream<WebhookRepresentation> getWebhooks() {
        this.permissions.realm().requireViewEvents();
        return this.webhooks.getWebhooksStream(this.realm).map(w -> this.toRepresentation((WebhookModel)w));
    }

    private WebhookRepresentation toRepresentation(WebhookModel w) {
        WebhookRepresentation webhook = new WebhookRepresentation();
        webhook.setId(w.getId());
        webhook.setEnabled(w.isEnabled());
        webhook.setUrl(w.getUrl());
        UserModel u = w.getCreatedBy();
        if (u != null) {
            webhook.setCreatedBy(u.getId());
        }
        webhook.setCreatedAt(w.getCreatedAt());
        webhook.setRealm(w.getRealm().getName());
        webhook.setEventTypes(w.getEventTypes());
        return webhook;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createWebhook(WebhookRepresentation rep) {
        this.permissions.realm().requireManageEvents();
        this.validateWebhook(rep);
        WebhookModel w = this.webhooks.createWebhook(this.realm, rep.getUrl(), this.auth.getUser());
        this.mergeWebhook(rep, w);
        URI location = AdminRoot.realmsUrl((UriInfo)this.session.getContext().getUri()).path(this.realm.getName()).path("webhooks").path(w.getId()).build(new Object[0]);
        return Response.created((URI)location).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public WebhookRepresentation getWebhook(@PathParam(value="id") String id) {
        this.permissions.realm().requireViewEvents();
        WebhookModel w = this.webhooks.getWebhookById(this.realm, id);
        if (w != null) {
            return this.toRepresentation(w);
        }
        throw new NotFoundException(String.format("no webhook with id %s", id));
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    public Response updateWebhook(@PathParam(value="id") String id, WebhookRepresentation rep) {
        this.permissions.realm().requireManageEvents();
        this.validateWebhook(rep);
        WebhookModel w = this.webhooks.getWebhookById(this.realm, id);
        if (w == null) {
            throw new NotFoundException(String.format("no webhook with id %s", id));
        }
        this.mergeWebhook(rep, w);
        return Response.noContent().build();
    }

    private void validateWebhook(WebhookRepresentation rep) {
        if (rep == null) {
            throw new BadRequestException("webhook cannot be empty");
        }
        if (rep.getUrl() == null) {
            throw new BadRequestException("url cannot be empty");
        }
        try {
            new URI(rep.getUrl()).parseServerAuthority();
        }
        catch (URISyntaxException e) {
            throw new BadRequestException(rep.getUrl() + " not a URL");
        }
    }

    private void mergeWebhook(WebhookRepresentation rep, WebhookModel w) {
        w.setUrl(rep.getUrl());
        w.setEnabled(rep.isEnabled());
        if (rep.getEventTypes() != null) {
            w.removeEventTypes();
            rep.getEventTypes().forEach(t -> w.addEventType((String)t));
        }
        if (rep.getSecret() != null && !"".equals(rep.getSecret())) {
            w.setSecret(rep.getSecret());
        }
        if (rep.getAlgorithm() != null && !"".equals(rep.getAlgorithm())) {
            w.setAlgorithm(rep.getAlgorithm());
        } else {
            w.setAlgorithm("HmacSHA256");
        }
    }

    @DELETE
    @Path(value="{id}")
    public Response removeWebhook(@PathParam(value="id") String id) {
        this.permissions.realm().requireManageEvents();
        this.getWebhook(id);
        this.webhooks.removeWebhook(this.realm, id);
        return Response.noContent().build();
    }
}

