/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.magic.auth;

import com.google.common.collect.ImmutableList;
import io.phasetwo.keycloak.magic.MagicLink;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;

public class EmailOtpAuthenticator
implements Authenticator {
    private static final Logger log = Logger.getLogger(EmailOtpAuthenticator.class);
    public static final String USER_AUTH_NOTE_OTP_CODE = "user-auth-note-otp-code";
    public static final String FORM_PARAM_OTP_CODE = "otp";

    public void authenticate(AuthenticationFlowContext context) {
        this.challenge(context, null);
    }

    private void challenge(AuthenticationFlowContext context, FormMessage errorMessage) {
        this.sendOtp(context);
        LoginFormsProvider form = context.form().setExecution(context.getExecution().getId());
        if (errorMessage != null) {
            form.setErrors((List)ImmutableList.of((Object)errorMessage));
        }
        Response response = form.createForm("otp-form.ftl");
        context.challenge(response);
    }

    private void sendOtp(AuthenticationFlowContext context) {
        if (context.getAuthenticationSession().getAuthNote(USER_AUTH_NOTE_OTP_CODE) != null) {
            log.debugf("Skipping sending OTP email to %s because auth note isn't empty", (Object)context.getUser().getEmail());
            return;
        }
        String code = String.format("%06d", ThreadLocalRandom.current().nextInt(999999));
        boolean sent = MagicLink.sendOtpEmail(context.getSession(), context.getUser(), code);
        if (sent) {
            log.debugf("Sent OTP code %s to email %s", (Object)code, (Object)context.getUser().getEmail());
            context.getAuthenticationSession().setAuthNote(USER_AUTH_NOTE_OTP_CODE, code);
        }
    }

    public void action(AuthenticationFlowContext context) {
        log.debug((Object)"EmailOtpAuthenticator.action");
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        if (formData.containsKey((Object)"resend")) {
            context.getAuthenticationSession().removeAuthNote(USER_AUTH_NOTE_OTP_CODE);
            this.challenge(context, null);
            return;
        }
        String code = (String)formData.getFirst((Object)FORM_PARAM_OTP_CODE);
        log.debugf("Got %s for OTP code in form", (Object)code);
        try {
            if (code != null && code.equals(context.getAuthenticationSession().getAuthNote(USER_AUTH_NOTE_OTP_CODE))) {
                context.getAuthenticationSession().removeAuthNote(USER_AUTH_NOTE_OTP_CODE);
                context.getAuthenticationSession().getAuthenticatedUser().setEmailVerified(true);
                context.success();
                return;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error comparing OTP code to form", (Throwable)e);
        }
        context.getEvent().error("invalid_user_credentials");
        this.challenge(context, new FormMessage("invalidAccessCodeMessage", new Object[0]));
    }

    public boolean requiresUser() {
        return true;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

