/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.keycloak.magic.auth.token;

import io.phasetwo.keycloak.magic.auth.token.MagicLinkActionToken;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.authentication.actiontoken.AbstractActionTokenHandler;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.sessions.AuthenticationSessionModel;

public class MagicLinkActionTokenHandler
extends AbstractActionTokenHandler<MagicLinkActionToken> {
    private static final Logger log = Logger.getLogger(MagicLinkActionTokenHandler.class);

    public MagicLinkActionTokenHandler() {
        super("ext-magic-link", MagicLinkActionToken.class, "invalidRequestMessage", EventType.EXECUTE_ACTION_TOKEN, "invalid_request");
    }

    public AuthenticationSessionModel startFreshAuthenticationSession(MagicLinkActionToken token, ActionTokenContext<MagicLinkActionToken> tokenContext) {
        return tokenContext.createAuthenticationSessionForClient(token.getIssuedFor());
    }

    public boolean canUseTokenRepeatedly(MagicLinkActionToken token, ActionTokenContext<MagicLinkActionToken> tokenContext) {
        return token.getActionTokenPersistent();
    }

    public Response handleToken(MagicLinkActionToken token, ActionTokenContext<MagicLinkActionToken> tokenContext) {
        log.infof("handleToken for iss:%s, user:%s", (Object)token.getIssuedFor(), (Object)token.getUserId());
        UserModel user = tokenContext.getAuthenticationSession().getAuthenticatedUser();
        AuthenticationSessionModel authSession = tokenContext.getAuthenticationSession();
        ClientModel client = authSession.getClient();
        String redirectUri = token.getRedirectUri() != null ? token.getRedirectUri() : ResolveRelative.resolveRelativeUri((KeycloakSession)tokenContext.getSession(), (String)client.getRootUrl(), (String)client.getBaseUrl());
        log.infof("Using redirect_uri %s", (Object)redirectUri);
        String redirect = RedirectUtils.verifyRedirectUri((KeycloakSession)tokenContext.getSession(), (String)redirectUri, (ClientModel)authSession.getClient());
        if (redirect != null) {
            authSession.setAuthNote("SET_REDIRECT_URI_AFTER_REQUIRED_ACTIONS", "true");
            authSession.setRedirectUri(redirect);
            authSession.setClientNote("redirect_uri", redirectUri);
            if (token.getState() != null) {
                authSession.setClientNote("state", token.getState());
            }
            if (token.getNonce() != null) {
                authSession.setClientNote("nonce", token.getNonce());
                authSession.setUserSessionNote("nonce", token.getNonce());
            }
        }
        if (token.getScope() != null) {
            authSession.setClientNote("scope", token.getScope());
            AuthenticationManager.setClientScopesInSession((AuthenticationSessionModel)authSession);
        }
        if (token.getRememberMe() != null && token.getRememberMe().booleanValue()) {
            authSession.setAuthNote("remember_me", "true");
            tokenContext.getEvent().detail("remember_me", "true");
        } else {
            authSession.removeAuthNote("remember_me");
        }
        user.setEmailVerified(true);
        String nextAction = AuthenticationManager.nextRequiredAction((KeycloakSession)tokenContext.getSession(), (AuthenticationSessionModel)authSession, (HttpRequest)tokenContext.getRequest(), (EventBuilder)tokenContext.getEvent());
        return AuthenticationManager.redirectToRequiredActions((KeycloakSession)tokenContext.getSession(), (RealmModel)tokenContext.getRealm(), (AuthenticationSessionModel)authSession, (UriInfo)tokenContext.getUriInfo(), (String)nextAction);
    }
}

