/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth;

import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationProvider;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public class ActiveOrganizationAuthenticator
implements Authenticator {
    private static final Logger log = Logger.getLogger(ActiveOrganizationAuthenticator.class);
    private final OrganizationProvider provider;
    private static final String BROWSER_ACCOUNT_HINT_PARAM = "client_request_param_account_hint";
    private static final String DIRECT_ACCOUNT_HINT = "account_hint";
    private static final String ERROR_FORM = "error.ftl";

    public ActiveOrganizationAuthenticator(KeycloakSession session) {
        this.provider = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
    }

    public void authenticate(AuthenticationFlowContext context) {
        if (this.requestHasAccountHintParam(context)) {
            this.evaluateAuthenticationWithAccountHint(context);
        } else if (this.shouldChallengeForOrganizationSelection(context)) {
            this.tryOrganizationSelectionChallenge(context);
        } else {
            context.success();
        }
    }

    private boolean requestHasAccountHintParam(AuthenticationFlowContext context) {
        String browserAccountHintValue = this.getAccountHintValueFromBrowserRequest(context);
        String directGrantAccountHintValue = this.getAccountHintValueFromDirectGrantRequest(context);
        return browserAccountHintValue != null || directGrantAccountHintValue != null;
    }

    private String getAccountHintValueFromBrowserRequest(AuthenticationFlowContext context) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        return authSession.getClientNote(BROWSER_ACCOUNT_HINT_PARAM);
    }

    private String getAccountHintValueFromDirectGrantRequest(AuthenticationFlowContext context) {
        HttpRequest httpRequest = context.getHttpRequest();
        UriInfo uriInfo = httpRequest.getUri();
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        return (String)queryParams.getFirst((Object)DIRECT_ACCOUNT_HINT);
    }

    private void evaluateAuthenticationWithAccountHint(AuthenticationFlowContext context) {
        String organizationId = this.getOrganizationIdFromAccountHint(context);
        this.evaluateAuthenticationChallenge(context, organizationId);
    }

    private String getOrganizationIdFromAccountHint(AuthenticationFlowContext context) {
        String accountHint = this.getAccountHintValueFromBrowserRequest(context);
        if (accountHint != null) {
            return accountHint;
        }
        return this.getAccountHintValueFromDirectGrantRequest(context);
    }

    private void evaluateAuthenticationChallenge(AuthenticationFlowContext context, String organizationId) {
        if (this.hasMembership(context, organizationId)) {
            this.updateActiveOrganizationAttributeAndSucceedChallenge(context, organizationId);
        } else {
            this.failChallenge(context, "invalidOrganizationError");
        }
    }

    private boolean hasMembership(AuthenticationFlowContext context, String organizationId) {
        if (this.provider.getUserOrganizationsStream(context.getRealm(), context.getUser()).noneMatch(org -> org.getId().equals(organizationId))) {
            log.errorf("User isn't a member of this organization", new Object[0]);
            return false;
        }
        return true;
    }

    private void updateActiveOrganizationAttributeAndSucceedChallenge(AuthenticationFlowContext context, String organizationIdFromHint) {
        log.debugf("Authentication Challenge Success", new Object[0]);
        context.getUser().setAttribute("org.ro.active", Collections.singletonList(organizationIdFromHint));
        context.success();
    }

    private void failChallenge(AuthenticationFlowContext context, String errorMessage) {
        Response errorResponse;
        log.debugf("Authentication Challenge Failure", new Object[0]);
        try {
            errorResponse = context.form().setError(errorMessage, new Object[0]).createForm(ERROR_FORM);
        }
        catch (Exception e) {
            errorResponse = Response.status((int)401).build();
        }
        context.failureChallenge(AuthenticationFlowError.GENERIC_AUTHENTICATION_ERROR, errorResponse);
    }

    private boolean shouldChallengeForOrganizationSelection(AuthenticationFlowContext context) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        String prompt = authSession.getClientNote("prompt");
        return prompt != null && prompt.contains("select_account");
    }

    private void tryOrganizationSelectionChallenge(AuthenticationFlowContext context) {
        List<OrganizationModel> organizations = this.provider.getUserOrganizationsStream(context.getRealm(), context.getUser()).toList();
        if (organizations.isEmpty()) {
            log.warnf("Select organization challenge couldn't be performed because the user has no organization.", new Object[0]);
            this.failChallenge(context, "noOrganizationError");
        } else if (organizations.size() == 1) {
            log.infof("User has 1 organization, skip organization selection challenge.", new Object[0]);
            this.updateActiveOrganizationAttributeAndSucceedChallenge(context, organizations.get(0).getId());
        } else {
            LoginFormsProvider loginForm = context.form();
            loginForm.setAttribute("organizations", organizations);
            context.challenge(loginForm.createForm("select-organization.ftl"));
        }
    }

    public void action(AuthenticationFlowContext context) {
        HttpRequest request = context.getHttpRequest();
        MultivaluedMap formData = request.getDecodedFormParameters();
        String organizationId = (String)formData.getFirst((Object)"organizationId");
        if (organizationId == null || organizationId.isEmpty()) {
            log.errorf("No selected organization", new Object[0]);
            this.failChallenge(context, "invalidOrganizationError");
        } else {
            this.evaluateAuthenticationChallenge(context, organizationId);
        }
    }

    public boolean requiresUser() {
        return true;
    }

    public boolean configuredFor(KeycloakSession keycloakSession, RealmModel realmModel, UserModel userModel) {
        return true;
    }

    public void setRequiredActions(KeycloakSession keycloakSession, RealmModel realmModel, UserModel userModel) {
    }

    public void close() {
    }
}

