/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth;

import com.google.auto.service.AutoService;
import io.phasetwo.service.Orgs;
import io.phasetwo.service.auth.ActiveOrganizationAuthenticator;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.ProviderConfigProperty;

@AutoService(value={AuthenticatorFactory.class})
public class ActiveOrganizationAuthenticatorFactory
implements AuthenticatorFactory {
    private static final Logger log = Logger.getLogger(ActiveOrganizationAuthenticatorFactory.class);
    public static final String PROVIDER_ID = "ext-select-org";
    public static final String PROVIDER_DISPLAY = "Select Organization";
    public static final String PROVIDER_HELP_TEXT = "Select the current Organization on Login";
    private static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return PROVIDER_DISPLAY;
    }

    public String getReferenceCategory() {
        return "organization";
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return PROVIDER_HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public Authenticator create(KeycloakSession session) {
        return new ActiveOrganizationAuthenticator(session);
    }

    public void init(Config.Scope scope) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            if (event instanceof RealmModel.RealmPostCreateEvent) {
                this.createOrgBrowserFlow(((RealmModel.RealmPostCreateEvent)event).getCreatedRealm());
                this.createOrgDirectGrantFlow(((RealmModel.RealmPostCreateEvent)event).getCreatedRealm());
            } else if (event instanceof PostMigrationEvent) {
                log.debug((Object)"PostMigrationEvent");
                if (Orgs.KC_ORGS_SKIP_MIGRATION == null) {
                    log.info((Object)"initializing active organization user profile attribute following migration");
                    KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, this::postMigrationCreateAuthFlow);
                }
            }
        });
    }

    public void close() {
    }

    private void postMigrationCreateAuthFlow(KeycloakSession session) {
        log.debug((Object)"ActiveOrganizationAuthenticatorFactory::postMigrationCreateAuthFlow");
        session.realms().getRealmsStream().forEach(realm -> {
            this.createOrgBrowserFlow((RealmModel)realm);
            this.createOrgDirectGrantFlow((RealmModel)realm);
        });
    }

    private void createOrgBrowserFlow(RealmModel realm) {
        AuthenticationFlowModel browser = realm.getFlowByAlias("Org Browser Flow");
        if (browser != null) {
            log.infof("%s flow exists. Skipping.", (Object)"Org Browser Flow");
            return;
        }
        log.infof("creating built-in auth flow for %s", (Object)"Org Browser Flow");
        browser = new AuthenticationFlowModel();
        browser.setAlias("Org Browser Flow");
        browser.setDescription("Browser flow with select organization step.");
        browser.setProviderId("basic-flow");
        browser.setTopLevel(true);
        browser.setBuiltIn(true);
        browser = realm.addAuthenticationFlow(browser);
        this.cookieSubFlow(browser.getId(), realm);
        this.identityProviderSubFlow(browser.getId(), realm);
        this.usernamePasswordSubFlow(browser.getId(), realm);
    }

    private void createOrgDirectGrantFlow(RealmModel realm) {
        AuthenticationFlowModel grant = realm.getFlowByAlias("Org Direct Grant Flow");
        if (grant != null) {
            log.infof("%s flow exists. Skipping.", (Object)"Org Direct Grant Flow");
            return;
        }
        log.infof("creating built-in auth flow for %s", (Object)"Org Direct Grant Flow");
        grant = new AuthenticationFlowModel();
        grant.setAlias("Org Direct Grant Flow");
        grant.setDescription("Direct grant flow with select organization step.");
        grant.setProviderId("basic-flow");
        grant.setTopLevel(true);
        grant.setBuiltIn(true);
        grant = realm.addAuthenticationFlow(grant);
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setParentFlow(grant.getId());
        execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
        execution.setAuthenticator("direct-grant-validate-username");
        execution.setPriority(10);
        execution.setAuthenticatorFlow(false);
        realm.addAuthenticatorExecution(execution);
        execution = new AuthenticationExecutionModel();
        execution.setParentFlow(grant.getId());
        execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
        execution.setAuthenticator("direct-grant-validate-password");
        execution.setPriority(20);
        execution.setAuthenticatorFlow(false);
        realm.addAuthenticatorExecution(execution);
        this.conditionalOtp(grant.getId(), realm, "Org Direct Grant - Conditional OTP", 30);
        this.selectOrgExecution(grant.getId(), realm, 30);
    }

    private void cookieSubFlow(String parentFlowId, RealmModel realm) {
        AuthenticationFlowModel cookiesSubFlow = new AuthenticationFlowModel();
        cookiesSubFlow.setTopLevel(false);
        cookiesSubFlow.setBuiltIn(true);
        cookiesSubFlow.setAlias("Cookies Sub-Flow");
        cookiesSubFlow.setDescription("Cookie sub-flow which can be used to switch org.");
        cookiesSubFlow.setProviderId("basic-flow");
        cookiesSubFlow = realm.addAuthenticationFlow(cookiesSubFlow);
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setParentFlow(parentFlowId);
        execution.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE);
        execution.setFlowId(cookiesSubFlow.getId());
        execution.setPriority(10);
        execution.setAuthenticatorFlow(true);
        realm.addAuthenticatorExecution(execution);
        execution = new AuthenticationExecutionModel();
        execution.setParentFlow(cookiesSubFlow.getId());
        execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
        execution.setAuthenticator("auth-cookie");
        execution.setPriority(10);
        execution.setAuthenticatorFlow(false);
        realm.addAuthenticatorExecution(execution);
        this.selectOrgExecution(cookiesSubFlow.getId(), realm, 20);
    }

    private void identityProviderSubFlow(String parentFlowId, RealmModel realm) {
        AuthenticationFlowModel idpSubFLow = new AuthenticationFlowModel();
        idpSubFLow.setTopLevel(false);
        idpSubFLow.setBuiltIn(true);
        idpSubFLow.setAlias("IDP Sub-Flow");
        idpSubFLow.setDescription("IDP sub-flow to select org.");
        idpSubFLow.setProviderId("basic-flow");
        idpSubFLow = realm.addAuthenticationFlow(idpSubFLow);
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setParentFlow(parentFlowId);
        execution.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE);
        execution.setFlowId(idpSubFLow.getId());
        execution.setPriority(20);
        execution.setAuthenticatorFlow(true);
        realm.addAuthenticatorExecution(execution);
        execution = new AuthenticationExecutionModel();
        execution.setParentFlow(idpSubFLow.getId());
        execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
        execution.setAuthenticator("identity-provider-redirector");
        execution.setPriority(10);
        execution.setAuthenticatorFlow(false);
        realm.addAuthenticatorExecution(execution);
        this.selectOrgExecution(idpSubFLow.getId(), realm, 20);
    }

    private void usernamePasswordSubFlow(String parentFlowId, RealmModel realm) {
        AuthenticationFlowModel usernamePasswordSubFlow = new AuthenticationFlowModel();
        usernamePasswordSubFlow.setTopLevel(false);
        usernamePasswordSubFlow.setBuiltIn(true);
        usernamePasswordSubFlow.setAlias("Forms Sub-Flow");
        usernamePasswordSubFlow.setDescription("Username, password, otp and other auth forms.");
        usernamePasswordSubFlow.setProviderId("basic-flow");
        usernamePasswordSubFlow = realm.addAuthenticationFlow(usernamePasswordSubFlow);
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setParentFlow(parentFlowId);
        execution.setRequirement(AuthenticationExecutionModel.Requirement.ALTERNATIVE);
        execution.setFlowId(usernamePasswordSubFlow.getId());
        execution.setPriority(30);
        execution.setAuthenticatorFlow(true);
        realm.addAuthenticatorExecution(execution);
        execution = new AuthenticationExecutionModel();
        execution.setParentFlow(usernamePasswordSubFlow.getId());
        execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
        execution.setAuthenticator("auth-username-password-form");
        execution.setPriority(10);
        execution.setAuthenticatorFlow(false);
        realm.addAuthenticatorExecution(execution);
        this.conditionalOtp(usernamePasswordSubFlow.getId(), realm, "Org Browser - Conditional OTP", 20);
        this.selectOrgExecution(usernamePasswordSubFlow.getId(), realm, 30);
    }

    private void selectOrgExecution(String parentFlowId, RealmModel realm, int priority) {
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setParentFlow(parentFlowId);
        execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
        execution.setAuthenticator(PROVIDER_ID);
        execution.setPriority(priority);
        execution.setAuthenticatorFlow(false);
        realm.addAuthenticatorExecution(execution);
    }

    private void conditionalOtp(String parentFlowId, RealmModel realm, String alias, int priority) {
        AuthenticationFlowModel conditionalOTP = new AuthenticationFlowModel();
        conditionalOTP.setTopLevel(false);
        conditionalOTP.setBuiltIn(true);
        conditionalOTP.setAlias(alias);
        conditionalOTP.setDescription("Flow to determine if the OTP is required for the authentication");
        conditionalOTP.setProviderId("basic-flow");
        conditionalOTP = realm.addAuthenticationFlow(conditionalOTP);
        AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
        execution.setParentFlow(parentFlowId);
        execution.setRequirement(AuthenticationExecutionModel.Requirement.CONDITIONAL);
        execution.setFlowId(conditionalOTP.getId());
        execution.setPriority(priority);
        execution.setAuthenticatorFlow(true);
        realm.addAuthenticatorExecution(execution);
        execution = new AuthenticationExecutionModel();
        execution.setParentFlow(conditionalOTP.getId());
        execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
        execution.setAuthenticator("conditional-user-configured");
        execution.setPriority(10);
        execution.setAuthenticatorFlow(false);
        realm.addAuthenticatorExecution(execution);
        execution = new AuthenticationExecutionModel();
        execution.setParentFlow(conditionalOTP.getId());
        execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
        execution.setAuthenticator("auth-otp-form");
        execution.setPriority(20);
        execution.setAuthenticatorFlow(false);
        realm.addAuthenticatorExecution(execution);
    }
}

