/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth;

import io.phasetwo.service.auth.AuthenticatorConfigProperties;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.ConfigurableAuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

public abstract class BaseAuthenticatorFactory
implements AuthenticatorFactory,
ConfigurableAuthenticatorFactory {
    private static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.ALTERNATIVE, AuthenticationExecutionModel.Requirement.DISABLED};
    private final String providerId;
    private final AuthenticatorConfigProperties propsProvider;

    BaseAuthenticatorFactory(String providerId) {
        this(providerId, new AuthenticatorConfigProperties(){});
    }

    BaseAuthenticatorFactory(String providerId, AuthenticatorConfigProperties propsProvider) {
        this.providerId = providerId;
        this.propsProvider = propsProvider;
    }

    public AuthenticatorConfigProperties getPropsProvider() {
        return this.propsProvider;
    }

    public abstract Authenticator create(KeycloakSession var1);

    public abstract String getDisplayType();

    public abstract String getHelpText();

    public String getId() {
        return this.providerId;
    }

    public String getReferenceCategory() {
        return "alternate-auth";
    }

    public boolean isConfigurable() {
        return this.propsProvider.getConfigProperties().size() > 0;
    }

    public boolean isUserSetupAllowed() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return this.propsProvider.getConfigProperties();
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }
}

