/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth;

import com.google.auto.service.AutoService;
import io.phasetwo.service.auth.BaseAuthenticatorFactory;
import io.phasetwo.service.auth.DefaultAuthenticator;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.util.JsonSerialization;

@AutoService(value={AuthenticatorFactory.class})
public class DebugAuthenticatorFactory
extends BaseAuthenticatorFactory
implements DefaultAuthenticator {
    private static final Logger log = Logger.getLogger(DebugAuthenticatorFactory.class);
    public static final String PROVIDER_ID = "ext-auth-debugger";

    public DebugAuthenticatorFactory() {
        super(PROVIDER_ID);
    }

    public void authenticate(AuthenticationFlowContext context) {
        log.infof("DebugAuthenticator.authenticate: %s", (Object)context.getRealm().getName());
        this.debug(context);
        if (context.getExecution().getRequirement() == AuthenticationExecutionModel.Requirement.REQUIRED) {
            this.action(context);
        } else {
            context.attempted();
        }
    }

    public void action(AuthenticationFlowContext context) {
        log.infof("DebugAuthenticator.action: %s", (Object)context.getRealm().getName());
        this.debug(context);
        if (context.getExecution().getRequirement() == AuthenticationExecutionModel.Requirement.REQUIRED) {
            context.success();
        } else {
            context.attempted();
        }
    }

    private void debug(AuthenticationFlowContext context) {
        log.infof("requirement: %s", (Object)context.getExecution().getRequirement().toString());
        log.infof("clientNotes: %s", (Object)DebugAuthenticatorFactory.writeValueAsJson(context.getAuthenticationSession().getClientNotes()));
        log.infof("clientScopes: %s", (Object)DebugAuthenticatorFactory.writeValueAsJson(context.getAuthenticationSession().getClientScopes()));
        log.infof("userSessionNotes: %s", (Object)DebugAuthenticatorFactory.writeValueAsJson(context.getAuthenticationSession().getUserSessionNotes()));
    }

    private static String writeValueAsJson(Object o) {
        try {
            return JsonSerialization.writeValueAsString((Object)o);
        }
        catch (Exception e) {
            log.error((Object)"Error serializing", (Throwable)e);
            return null;
        }
    }

    @Override
    public Authenticator create(KeycloakSession session) {
        return this;
    }

    @Override
    public boolean isUserSetupAllowed() {
        return false;
    }

    @Override
    public String getHelpText() {
        return "Debugging use only.";
    }

    @Override
    public String getDisplayType() {
        return "Debugger";
    }

    @Override
    public String getReferenceCategory() {
        return "Debug";
    }
}

