/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth;

import com.google.auto.service.AutoService;
import io.phasetwo.service.auth.BaseAuthenticatorFactory;
import io.phasetwo.service.auth.DefaultAuthenticator;
import io.phasetwo.service.auth.PostOrgAuthFlow;
import io.phasetwo.service.model.InvitationModel;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationProvider;
import io.phasetwo.service.model.OrganizationRoleModel;
import io.phasetwo.service.util.Domains;
import io.phasetwo.service.util.IdentityProviders;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

@AutoService(value={AuthenticatorFactory.class})
public class OrgAddUserAuthenticatorFactory
extends BaseAuthenticatorFactory
implements DefaultAuthenticator {
    private static final Logger log = Logger.getLogger(OrgAddUserAuthenticatorFactory.class);
    public static final String PROVIDER_ID = "ext-auth-org-add-user";

    public OrgAddUserAuthenticatorFactory() {
        super(PROVIDER_ID);
    }

    public void authenticate(AuthenticationFlowContext context) {
        log.info((Object)"OrgAddUserAuthenticatorFactory.authenticate");
        this.addUser(context);
    }

    public void action(AuthenticationFlowContext context) {
        log.info((Object)"OrgAddUserAuthenticatorFactory.authenticate");
    }

    private void addUser(AuthenticationFlowContext context) {
        PostOrgAuthFlow.setStatus(context);
        BrokeredIdentityContext brokerContext = PostOrgAuthFlow.getBrokeredIdentityContext(context);
        if (!PostOrgAuthFlow.brokeredIdpEnabled(context, brokerContext)) {
            return;
        }
        Map idpConfig = brokerContext.getIdpConfig().getConfig();
        boolean idpIsShared = Boolean.parseBoolean(idpConfig.getOrDefault("home.idp.discovery.shared", "false"));
        if (idpConfig.containsKey("home.idp.discovery.org")) {
            OrganizationProvider orgs = (OrganizationProvider)context.getSession().getProvider(OrganizationProvider.class);
            Set<String> orgIds = IdentityProviders.getAttributeMultivalued(idpConfig, "home.idp.discovery.org");
            orgIds.forEach(orgId -> {
                OrganizationModel org = orgs.getOrganizationById(context.getRealm(), (String)orgId);
                if (org == null) {
                    log.infof("idpConfig  %s contained %s, but org not found", (Object)"home.idp.discovery.org", orgId);
                    return;
                }
                OrgAddUserAuthenticatorFactory.handleOrganizationMembership(context, org, idpIsShared);
                if (org.hasMembership(context.getUser())) {
                    orgs.getUserInvitationsStream(context.getRealm(), context.getUser()).filter(invitationModel -> invitationModel.getOrganization().getId().equals(org.getId())).forEach(invitationModel -> {
                        this.addRolesFromInvitation((InvitationModel)invitationModel, context.getUser());
                        invitationModel.getOrganization().revokeInvitation(invitationModel.getId());
                        context.getEvent().clone().event(EventType.IDENTITY_PROVIDER_POST_LOGIN).detail("org_id", invitationModel.getOrganization().getId()).detail("invitation_id", invitationModel.getId()).user(context.getUser()).error("User invitation revoked.");
                    });
                }
            });
        } else {
            log.infof("No organization owns IdP %s", (Object)brokerContext.getIdpConfig().getAlias());
        }
    }

    private static void handleOrganizationMembership(AuthenticationFlowContext context, OrganizationModel org, boolean idpIsShared) {
        Optional<String> userDomain;
        if (!org.hasMembership(context.getUser()) && !idpIsShared) {
            log.infof("granting membership to %s for user %s", (Object)org.getName(), (Object)context.getUser().getUsername());
            org.grantMembership(context.getUser());
            context.getEvent().user(context.getUser()).detail("joined_organization", org.getId()).success();
        }
        if (!org.hasMembership(context.getUser()) && idpIsShared && (userDomain = Domains.extract(context.getUser().getEmail())).isPresent() && Domains.supportsDomain(org.getDomains(), userDomain.get())) {
            log.infof("granting membership to %s for user %s", (Object)org.getName(), (Object)context.getUser().getUsername());
            org.grantMembership(context.getUser());
            context.getEvent().user(context.getUser()).detail("joined_organization", org.getId()).success();
        }
    }

    void addRolesFromInvitation(InvitationModel invitation, UserModel user) {
        invitation.getRoles().forEach(r -> {
            OrganizationRoleModel role = invitation.getOrganization().getRoleByName((String)r);
            if (role == null) {
                log.debugf("No org role found for invitation role %s. Skipping...", r);
            } else {
                role.grantRole(user);
            }
        });
    }

    @Override
    public boolean requiresUser() {
        return true;
    }

    @Override
    public Authenticator create(KeycloakSession session) {
        return this;
    }

    @Override
    public boolean isUserSetupAllowed() {
        return false;
    }

    @Override
    public String getHelpText() {
        return "Adds a user to an organization if an organization-owned IdP was used to log in. Use only in Post Login Flows.";
    }

    @Override
    public String getDisplayType() {
        return "Add User to Org";
    }

    @Override
    public String getReferenceCategory() {
        return "Post Broker";
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        factory.register(ev -> {
            if (ev instanceof RealmModel.RealmPostCreateEvent) {
                PostOrgAuthFlow.realmPostCreate((RealmModel.RealmPostCreateEvent)ev, PROVIDER_ID);
            }
        });
    }
}

