/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth;

import com.google.auto.service.AutoService;
import io.phasetwo.service.auth.BaseAuthenticatorFactory;
import io.phasetwo.service.auth.DefaultAuthenticator;
import io.phasetwo.service.auth.PostOrgAuthFlow;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;

@AutoService(value={AuthenticatorFactory.class})
public class OrgNoteAuthenticatorFactory
extends BaseAuthenticatorFactory
implements DefaultAuthenticator {
    private static final Logger log = Logger.getLogger(OrgNoteAuthenticatorFactory.class);
    public static final String PROVIDER_ID = "ext-auth-org-note";

    public OrgNoteAuthenticatorFactory() {
        super(PROVIDER_ID);
    }

    public void authenticate(AuthenticationFlowContext context) {
        log.info((Object)"OrgNoteAuthenticatorFactory.authenticate");
        this.setNote(context);
    }

    public void action(AuthenticationFlowContext context) {
        log.info((Object)"OrgNoteAuthenticatorFactory.action");
    }

    private void setNote(AuthenticationFlowContext context) {
        PostOrgAuthFlow.setStatus(context);
        BrokeredIdentityContext brokerContext = PostOrgAuthFlow.getBrokeredIdentityContext(context);
        if (!PostOrgAuthFlow.brokeredIdpEnabled(context, brokerContext)) {
            return;
        }
        Map idpConfig = brokerContext.getIdpConfig().getConfig();
        if (idpConfig != null && idpConfig.containsKey("home.idp.discovery.org")) {
            log.infof("Set auth/session note %s = %s for IdP %s", (Object)"org_id", idpConfig.get("home.idp.discovery.org"), (Object)brokerContext.getIdpConfig().getAlias());
            context.getAuthenticationSession().setAuthNote("org_id", (String)idpConfig.get("home.idp.discovery.org"));
            context.getAuthenticationSession().setUserSessionNote("org_id", (String)idpConfig.get("home.idp.discovery.org"));
        } else {
            log.infof("No organization owns IdP %s", (Object)brokerContext.getIdpConfig().getAlias());
        }
    }

    @Override
    public boolean requiresUser() {
        return true;
    }

    @Override
    public Authenticator create(KeycloakSession session) {
        return this;
    }

    @Override
    public boolean isUserSetupAllowed() {
        return false;
    }

    @Override
    public String getHelpText() {
        return "Sets an auth and user session notes of the org_id if an organization-owned IdP was used to log in. Use only in Post Login Flows.";
    }

    @Override
    public String getDisplayType() {
        return "Org To Auth/Session Note";
    }

    @Override
    public String getReferenceCategory() {
        return "Post Broker";
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        factory.register(ev -> {
            if (ev instanceof RealmModel.RealmPostCreateEvent) {
                PostOrgAuthFlow.realmPostCreate((RealmModel.RealmPostCreateEvent)ev, PROVIDER_ID);
            }
        });
    }
}

