/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth;

import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.TokenVerifier;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.Authenticator;
import org.keycloak.common.VerificationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.sessions.AuthenticationSessionModel;

public class PortalLinkAuthenticator
implements Authenticator {
    private static final Logger log = Logger.getLogger(PortalLinkAuthenticator.class);
    private final KeycloakSession session;

    public PortalLinkAuthenticator(KeycloakSession session) {
        this.session = session;
    }

    public void authenticate(AuthenticationFlowContext context) {
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        RealmModel realm = context.getRealm();
        String tokenString = authSession.getAuthNote("ORIGINAL_ACTION_TOKEN");
        log.infof("Got token string from auth note (%s): %s", (Object)"ORIGINAL_ACTION_TOKEN", (Object)tokenString);
        if (tokenString == null) {
            context.attempted();
            return;
        }
        try {
            JsonWebToken token = TokenVerifier.create((String)tokenString, JsonWebToken.class).getToken();
            log.infof("found user %s in token", (Object)token.getSubject());
            UserModel user = this.session.users().getUserById(realm, token.getSubject());
            context.setUser(user);
            context.success();
        }
        catch (VerificationException ex) {
            log.error((Object)"Error handling action token", (Throwable)ex);
            context.failure(AuthenticationFlowError.INTERNAL_ERROR, context.form().setError("invalidParameterMessage", new Object[0]).createErrorPage(Response.Status.INTERNAL_SERVER_ERROR));
        }
        context.attempted();
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void action(AuthenticationFlowContext context) {
        context.success();
    }

    public void close() {
    }
}

