/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth;

import com.google.auto.service.AutoService;
import io.phasetwo.service.auth.PortalLinkAuthenticator;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.ConfigurableAuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

@AutoService(value={AuthenticatorFactory.class})
public class PortalLinkAuthenticatorFactory
implements AuthenticatorFactory,
ConfigurableAuthenticatorFactory {
    private static final Logger log = Logger.getLogger(PortalLinkAuthenticatorFactory.class);
    public static final String PROVIDER_ID = "ext-portal-link";
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.ALTERNATIVE, AuthenticationExecutionModel.Requirement.DISABLED};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getId() {
        return PROVIDER_ID;
    }

    public Authenticator create(KeycloakSession session) {
        return new PortalLinkAuthenticator(session);
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public boolean isConfigurable() {
        return false;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getHelpText() {
        return "Portal Link.";
    }

    public String getDisplayType() {
        return "Portal Link";
    }

    public String getReferenceCategory() {
        return "Portal Link";
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }
}

