/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth;

import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.authenticators.broker.util.SerializedBrokeredIdentityContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.sessions.AuthenticationSessionModel;

public class PostOrgAuthFlow {
    private static final Logger log = Logger.getLogger(PostOrgAuthFlow.class);

    static void setStatus(AuthenticationFlowContext context) {
        if (context.getExecution().getRequirement() == AuthenticationExecutionModel.Requirement.REQUIRED) {
            context.success();
        } else {
            context.attempted();
        }
    }

    static BrokeredIdentityContext getBrokeredIdentityContext(AuthenticationFlowContext context) {
        AuthenticationSessionModel clientSession = context.getAuthenticationSession();
        SerializedBrokeredIdentityContext serializedCtx = SerializedBrokeredIdentityContext.readFromAuthenticationSession((AuthenticationSessionModel)clientSession, (String)"BROKERED_CONTEXT");
        if (serializedCtx == null) {
            serializedCtx = SerializedBrokeredIdentityContext.readFromAuthenticationSession((AuthenticationSessionModel)clientSession, (String)"PBL_BROKERED_IDENTITY_CONTEXT");
        }
        if (serializedCtx == null) {
            throw new AuthenticationFlowException("Not found serialized context in clientSession", AuthenticationFlowError.IDENTITY_PROVIDER_ERROR);
        }
        return serializedCtx.deserialize(context.getSession(), clientSession);
    }

    static boolean brokeredIdpEnabled(AuthenticationFlowContext context, BrokeredIdentityContext brokerContext) {
        if (!brokerContext.getIdpConfig().isEnabled()) {
            context.getEvent().user(context.getUser()).error("identity_provider_error");
            Response challengeResponse = context.form().setError("identityProviderUnexpectedErrorMessage", new Object[0]).createErrorPage(Response.Status.BAD_REQUEST);
            context.failureChallenge(AuthenticationFlowError.IDENTITY_PROVIDER_ERROR, challengeResponse);
            return false;
        }
        return true;
    }

    static void realmPostCreate(RealmModel.RealmPostCreateEvent event, String providerId) {
        boolean hasExecution;
        KeycloakSession session = event.getKeycloakSession();
        RealmModel realm = event.getCreatedRealm();
        AuthenticationFlowModel flow = realm.getFlowByAlias("post org broker login");
        if (flow == null) {
            log.infof("creating built-in auth flow for %s", (Object)"post org broker login");
            flow = new AuthenticationFlowModel();
            flow.setAlias("post org broker login");
            flow.setBuiltIn(true);
            flow.setProviderId("basic-flow");
            flow.setDescription("Post broker login flow used for organization IdPs.");
            flow.setTopLevel(true);
            flow = realm.addAuthenticationFlow(flow);
        }
        boolean bl = hasExecution = realm.getAuthenticationExecutionsStream(flow.getId()).filter(e -> providerId.equals(e.getAuthenticator())).count() > 0L;
        if (!hasExecution) {
            log.infof("adding execution %s for auth flow for %s", (Object)providerId, (Object)"post org broker login");
            ProviderFactory f = session.getKeycloakSessionFactory().getProviderFactory(Authenticator.class, providerId);
            AuthenticationExecutionModel execution = new AuthenticationExecutionModel();
            execution.setParentFlow(flow.getId());
            execution.setRequirement(AuthenticationExecutionModel.Requirement.REQUIRED);
            execution.setAuthenticatorFlow(false);
            execution.setAuthenticator(providerId);
            execution = realm.addAuthenticatorExecution(execution);
        }
    }
}

