/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth;

import io.phasetwo.service.auth.DefaultAuthenticator;
import io.phasetwo.service.util.Emails;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.authenticators.browser.AbstractUsernameFormAuthenticator;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.managers.AuthenticationManager;

class UsernameNoteAuthenticator
extends AbstractUsernameFormAuthenticator
implements DefaultAuthenticator {
    private static final Logger log = Logger.getLogger(UsernameNoteAuthenticator.class);

    UsernameNoteAuthenticator() {
    }

    public void authenticate(AuthenticationFlowContext context) {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        String loginHint = context.getAuthenticationSession().getClientNote("login_hint");
        String rememberMeUsername = AuthenticationManager.getRememberMeUsername((KeycloakSession)context.getSession());
        if (loginHint != null || rememberMeUsername != null) {
            if (loginHint != null) {
                formData.add((Object)"username", (Object)loginHint);
            } else {
                formData.add((Object)"username", (Object)rememberMeUsername);
                formData.add((Object)"rememberMe", (Object)"on");
            }
        }
        Response challengeResponse = this.challenge(context, (MultivaluedMap<String, String>)formData);
        context.challenge(challengeResponse);
    }

    protected Response challenge(AuthenticationFlowContext context, MultivaluedMap<String, String> formData) {
        LoginFormsProvider forms = context.form();
        if (!formData.isEmpty()) {
            forms.setFormData(formData);
        }
        return forms.createLoginUsername();
    }

    public void action(AuthenticationFlowContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        if (formData.containsKey((Object)"cancel")) {
            context.cancelLogin();
            return;
        }
        String username = this.setUserInContext(context, (MultivaluedMap<String, String>)formData);
        if (username == null) {
            return;
        }
        log.infof("username set in auth note %s.", (Object)username);
        if (context.getExecution().getRequirement() == AuthenticationExecutionModel.Requirement.REQUIRED) {
            context.success();
        } else {
            context.attempted();
        }
    }

    private String setUserInContext(AuthenticationFlowContext context, MultivaluedMap<String, String> inputData) {
        context.clearUser();
        String username = (String)inputData.getFirst((Object)"username");
        if (username != null && "".equalsIgnoreCase(username = username.trim())) {
            username = null;
        }
        if (username == null) {
            context.getEvent().error("user_not_found");
            Response challengeResponse = this.challenge(context, this.getDefaultChallengeMessage(context), "username");
            context.failureChallenge(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return null;
        }
        if (!Emails.isValidEmail(username)) {
            context.getEvent().error("invalid_email");
            Response challengeResponse = this.challenge(context, this.getDefaultChallengeMessage(context), "username");
            context.failureChallenge(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return null;
        }
        context.getEvent().detail("username", username);
        context.getAuthenticationSession().setAuthNote("ATTEMPTED_USERNAME", username);
        return username;
    }

    protected Response createLoginForm(LoginFormsProvider form) {
        return form.createLoginUsername();
    }

    protected String getDefaultChallengeMessage(AuthenticationFlowContext context) {
        return context.getRealm().isLoginWithEmailAllowed() ? "invalidUsernameOrEmailMessage" : "invalidUsernameMessage";
    }
}

