/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth.action;

import io.phasetwo.service.auth.action.PortalLinkActionToken;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.authentication.actiontoken.AbstractActionTokenHandler;
import org.keycloak.authentication.actiontoken.ActionTokenContext;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.utils.RedirectUtils;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.util.ResolveRelative;
import org.keycloak.sessions.AuthenticationSessionModel;

public class PortalLinkActionTokenHandler
extends AbstractActionTokenHandler<PortalLinkActionToken> {
    private static final Logger log = Logger.getLogger(PortalLinkActionTokenHandler.class);
    public static final String ORIGINAL_ACTION_TOKEN = "ORIGINAL_ACTION_TOKEN";

    public PortalLinkActionTokenHandler() {
        super("org-portal-link", PortalLinkActionToken.class, "invalidRequestMessage", EventType.EXECUTE_ACTION_TOKEN, "invalid_request");
    }

    public AuthenticationSessionModel startFreshAuthenticationSession(PortalLinkActionToken token, ActionTokenContext<PortalLinkActionToken> tokenContext) {
        return tokenContext.createAuthenticationSessionForClient(token.getIssuedFor());
    }

    public Response handleToken(PortalLinkActionToken token, ActionTokenContext<PortalLinkActionToken> tokenContext) {
        EventBuilder event = tokenContext.getEvent();
        log.infof("handleToken for iss:%s, org:%s, user:%s, rdu:%s", new Object[]{token.getIssuedFor(), token.getOrgId(), token.getUserId(), token.getRedirectUri()});
        UserModel user = tokenContext.getAuthenticationSession().getAuthenticatedUser();
        AuthenticationSessionModel authSession = tokenContext.getAuthenticationSession();
        ClientModel client = authSession.getClient();
        String redirectUri = token.getRedirectUri() != null ? token.getRedirectUri() : ResolveRelative.resolveRelativeUri((KeycloakSession)tokenContext.getSession(), (String)client.getRootUrl(), (String)client.getBaseUrl());
        log.infof("Using client_id %s redirect_uri %s", (Object)client.getClientId(), (Object)redirectUri);
        String redirect = RedirectUtils.verifyRedirectUri((KeycloakSession)tokenContext.getSession(), (String)redirectUri, (ClientModel)authSession.getClient());
        log.infof("Redirect after verify %s -> %s", (Object)redirectUri, (Object)redirect);
        if (redirect != null) {
            authSession.setAuthNote("SET_REDIRECT_URI_AFTER_REQUIRED_ACTIONS", "true");
            authSession.setRedirectUri(redirect);
            authSession.setClientNote("redirect_uri", redirectUri);
        }
        authSession.setUserSessionNote("org_id", token.getOrgId());
        event.detail("org_id", token.getOrgId()).success();
        String nextAction = AuthenticationManager.nextRequiredAction((KeycloakSession)tokenContext.getSession(), (AuthenticationSessionModel)authSession, (HttpRequest)tokenContext.getRequest(), (EventBuilder)tokenContext.getEvent());
        return AuthenticationManager.redirectToRequiredActions((KeycloakSession)tokenContext.getSession(), (RealmModel)tokenContext.getRealm(), (AuthenticationSessionModel)authSession, (UriInfo)tokenContext.getUriInfo(), (String)nextAction);
    }
}

