/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth.idp;

import io.phasetwo.service.auth.idp.LoginForm;
import io.phasetwo.service.auth.idp.LoginHint;
import io.phasetwo.service.auth.idp.RememberMe;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.models.IdentityProviderModel;

final class AuthenticationChallenge {
    private final AuthenticationFlowContext context;
    private final RememberMe rememberMe;
    private final LoginHint loginHint;
    private final LoginForm loginForm;

    AuthenticationChallenge(AuthenticationFlowContext context, RememberMe rememberMe, LoginHint loginHint, LoginForm loginForm) {
        this.context = context;
        this.rememberMe = rememberMe;
        this.loginHint = loginHint;
        this.loginForm = loginForm;
    }

    void forceChallenge() {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        String loginHintUsername = this.loginHint.getFromSession();
        String rememberMeUsername = this.rememberMe.getUserName();
        if (loginHintUsername != null || rememberMeUsername != null) {
            if (loginHintUsername != null) {
                formData.add((Object)"username", (Object)loginHintUsername);
            } else {
                formData.add((Object)"username", (Object)rememberMeUsername);
                formData.add((Object)"rememberMe", (Object)"on");
            }
        }
        Response challengeResponse = this.loginForm.create((MultivaluedMap<String, String>)formData);
        this.context.challenge(challengeResponse);
    }

    void forceChallenge(List<IdentityProviderModel> homeIdps) {
        this.context.forceChallenge(this.loginForm.create(homeIdps));
    }
}

