/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth.idp;

import io.phasetwo.service.auth.idp.Domain;
import io.phasetwo.service.auth.idp.DomainExtractor;
import io.phasetwo.service.auth.idp.HomeIdpDiscoveryConfig;
import io.phasetwo.service.auth.idp.IdentityProviderModelConfig;
import io.phasetwo.service.model.OrganizationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

final class HomeIdpDiscoverer {
    private static final Logger LOG = Logger.getLogger(HomeIdpDiscoverer.class);
    private final DomainExtractor domainExtractor;
    private final AuthenticationFlowContext context;

    HomeIdpDiscoverer(AuthenticationFlowContext context) {
        this(new DomainExtractor(new HomeIdpDiscoveryConfig(context.getAuthenticatorConfig())), context);
    }

    private HomeIdpDiscoverer(DomainExtractor domainExtractor, AuthenticationFlowContext context) {
        this.domainExtractor = domainExtractor;
        this.context = context;
    }

    public List<IdentityProviderModel> discoverForUser(String username) {
        Optional<Domain> emailDomain;
        String realmName = this.context.getRealm().getName();
        AuthenticatorConfigModel authenticatorConfig = this.context.getAuthenticatorConfig();
        LOG.tracef("Trying to discover home IdP for username '%s' in realm '%s' with authenticator config '%s'", (Object)username, (Object)realmName, (Object)(authenticatorConfig == null ? "<unconfigured>" : authenticatorConfig.getAlias()));
        List<IdentityProviderModel> homeIdps = new ArrayList<IdentityProviderModel>();
        UserModel user = this.context.getUser();
        if (user == null) {
            LOG.tracef("No user found in AuthenticationFlowContext. Extracting domain from provided username '%s'.", (Object)username);
            emailDomain = this.domainExtractor.extractFrom(username);
        } else {
            LOG.tracef("User found in AuthenticationFlowContext. Extracting domain from stored user '%s'.", (Object)user.getId());
            emailDomain = this.domainExtractor.extractFrom(user);
        }
        HomeIdpDiscoveryConfig config = new HomeIdpDiscoveryConfig(authenticatorConfig);
        if (config.requireVerifiedEmail() && "email".equalsIgnoreCase(config.userAttribute()) && !user.isEmailVerified()) {
            LOG.infof("Email of user %s not verified. Skipping discovery of linked IdPs", (Object)user.getId());
            return homeIdps;
        }
        if (emailDomain.isPresent()) {
            Domain domain = emailDomain.get();
            homeIdps = this.discoverHomeIdps(domain, user, username);
            if (homeIdps.isEmpty()) {
                LOG.infof("Could not find home IdP for domain '%s' and user '%s' in realm '%s'", (Object)domain, (Object)username, (Object)realmName);
            }
        } else {
            LOG.warnf("Could not extract domain from email address '%s'", (Object)username);
        }
        return homeIdps;
    }

    private List<IdentityProviderModel> discoverHomeIdps(Domain domain, UserModel user, String username) {
        Map<String, String> linkedIdps;
        HomeIdpDiscoveryConfig config = new HomeIdpDiscoveryConfig(this.context.getAuthenticatorConfig());
        if (user == null || !config.forwardToLinkedIdp()) {
            linkedIdps = Collections.emptyMap();
            LOG.tracef("User '%s' is not stored locally or forwarding to linked IdP is disabled. Skipping discovery of linked IdPs.", (Object)username);
        } else {
            LOG.tracef("Found local user '%s' and forwarding to linked IdP is enabled. Discovering linked IdPs.", (Object)username);
            linkedIdps = this.context.getSession().users().getFederatedIdentitiesStream(this.context.getRealm(), user).collect(Collectors.toMap(FederatedIdentityModel::getIdentityProvider, FederatedIdentityModel::getUserName));
        }
        List<IdentityProviderModel> enabledIdps = this.determineEnabledIdps();
        OrganizationProvider orgs = (OrganizationProvider)this.context.getSession().getProvider(OrganizationProvider.class);
        List<IdentityProviderModel> enabledIdpsWithMatchingDomain = orgs.getOrganizationsStreamForDomain(this.context.getRealm(), domain.toString(), config.requireVerifiedDomain()).flatMap(o -> o.getIdentityProvidersStream()).filter(IdentityProviderModel::isEnabled).collect(Collectors.toList());
        List<IdentityProviderModel> homeIdps = this.getLinkedIdpsFrom(enabledIdpsWithMatchingDomain, linkedIdps);
        if (homeIdps.isEmpty()) {
            if (!linkedIdps.isEmpty()) {
                homeIdps = this.getLinkedIdpsFrom(enabledIdps, linkedIdps);
            }
            if (homeIdps.isEmpty()) {
                homeIdps = enabledIdpsWithMatchingDomain;
                this.logFoundIdps("non-linked", "matching", homeIdps, domain, username);
            } else {
                this.logFoundIdps("non-linked", "non-matching", homeIdps, domain, username);
            }
        } else {
            this.logFoundIdps("linked", "matching", homeIdps, domain, username);
        }
        return homeIdps;
    }

    private void logFoundIdps(String idpQualifier, String domainQualifier, List<IdentityProviderModel> homeIdps, Domain domain, String username) {
        String homeIdpsString = homeIdps.stream().map(IdentityProviderModel::getAlias).collect(Collectors.joining(","));
        LOG.tracef("Found %s IdPs [%s] with %s domain '%s' for user '%s'", new Object[]{idpQualifier, homeIdpsString, domainQualifier, domain, username});
    }

    private List<IdentityProviderModel> getLinkedIdpsFrom(List<IdentityProviderModel> enabledIdpsWithMatchingDomain, Map<String, String> linkedIdps) {
        return enabledIdpsWithMatchingDomain.stream().filter(it -> linkedIdps.containsKey(it.getAlias())).collect(Collectors.toList());
    }

    private List<IdentityProviderModel> filterIdpsWithMatchingDomainFrom(List<IdentityProviderModel> enabledIdps, Domain domain, HomeIdpDiscoveryConfig config) {
        String userAttributeName = config.userAttribute();
        List<IdentityProviderModel> idpsWithMatchingDomain = enabledIdps.stream().filter(it -> new IdentityProviderModelConfig((IdentityProviderModel)it).supportsDomain(userAttributeName, domain)).collect(Collectors.toList());
        LOG.tracef("IdPs with matching domain '%s' for attribute '%s': %s", (Object)domain, (Object)userAttributeName, (Object)idpsWithMatchingDomain.stream().map(IdentityProviderModel::getAlias).collect(Collectors.joining(",")));
        return idpsWithMatchingDomain;
    }

    private List<IdentityProviderModel> determineEnabledIdps() {
        RealmModel realm = this.context.getRealm();
        List<IdentityProviderModel> enabledIdps = realm.getIdentityProvidersStream().filter(IdentityProviderModel::isEnabled).collect(Collectors.toList());
        LOG.tracef("Enabled IdPs in realm '%s': %s", (Object)realm.getName(), (Object)enabledIdps.stream().map(IdentityProviderModel::getAlias).collect(Collectors.joining(",")));
        return enabledIdps;
    }
}

