/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth.idp;

import io.phasetwo.service.auth.idp.HomeIdpAuthenticationFlowContext;
import io.phasetwo.service.auth.idp.RememberMe;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.authenticators.browser.AbstractUsernameFormAuthenticator;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

final class HomeIdpDiscoveryAuthenticator
extends AbstractUsernameFormAuthenticator {
    private static final Logger LOG = Logger.getLogger(HomeIdpDiscoveryAuthenticator.class);

    HomeIdpDiscoveryAuthenticator() {
    }

    public void authenticate(AuthenticationFlowContext authenticationFlowContext) {
        String loginHint;
        HomeIdpAuthenticationFlowContext context = new HomeIdpAuthenticationFlowContext(authenticationFlowContext);
        String attemptedUsername = this.getAttemptedUsername(authenticationFlowContext);
        if (attemptedUsername != null) {
            if (authenticationFlowContext.getExecution().getRequirement() == AuthenticationExecutionModel.Requirement.REQUIRED) {
                this.action(authenticationFlowContext);
            } else {
                authenticationFlowContext.attempted();
            }
            return;
        }
        if (context.loginPage().shouldByPass() && (loginHint = this.trimToNull(context.loginHint().getFromSession())) != null) {
            String username = this.setUserInContext(authenticationFlowContext, loginHint);
            List<IdentityProviderModel> homeIdps = context.discoverer().discoverForUser(username);
            if (!homeIdps.isEmpty()) {
                context.rememberMe().remember(username);
                this.redirectOrChallenge(context, username, homeIdps);
                return;
            }
        }
        context.authenticationChallenge().forceChallenge();
    }

    private String getAttemptedUsername(AuthenticationFlowContext context) {
        return this.trimToNull(context.getAuthenticationSession().getAuthNote("ATTEMPTED_USERNAME"));
    }

    private void redirectOrChallenge(HomeIdpAuthenticationFlowContext context, String username, List<IdentityProviderModel> homeIdps) {
        if (homeIdps.size() == 1 || context.config().forwardToFirstMatch()) {
            IdentityProviderModel homeIdp = homeIdps.get(0);
            context.loginHint().setInAuthSession(homeIdp, username);
            context.redirector().redirectTo(homeIdp);
        } else {
            context.authenticationChallenge().forceChallenge(homeIdps);
        }
    }

    public void action(AuthenticationFlowContext authenticationFlowContext) {
        MultivaluedMap formData = authenticationFlowContext.getHttpRequest().getDecodedFormParameters();
        if (formData.containsKey((Object)"cancel")) {
            LOG.debugf("Login canceled", new Object[0]);
            authenticationFlowContext.cancelLogin();
            return;
        }
        String username = this.setUserInContext(authenticationFlowContext, (String)formData.getFirst((Object)"username"));
        if (username == null) {
            LOG.debugf("No username in request", new Object[0]);
            return;
        }
        HomeIdpAuthenticationFlowContext context = new HomeIdpAuthenticationFlowContext(authenticationFlowContext);
        List<IdentityProviderModel> homeIdps = context.discoverer().discoverForUser(username);
        if (homeIdps.isEmpty()) {
            if (authenticationFlowContext.getExecution().getRequirement() == AuthenticationExecutionModel.Requirement.REQUIRED) {
                authenticationFlowContext.success();
            } else {
                authenticationFlowContext.attempted();
            }
        } else {
            RememberMe rememberMe = context.rememberMe();
            rememberMe.handleAction((MultivaluedMap<String, String>)formData);
            rememberMe.remember(username);
            this.redirectOrChallenge(context, username, homeIdps);
        }
    }

    private String setUserInContext(AuthenticationFlowContext context, String username) {
        context.clearUser();
        username = this.trimToNull(username);
        if (username == null) {
            LOG.debug((Object)"Could not find username in request. Trying attempted username from previous authenticator");
            username = this.getAttemptedUsername(context);
        }
        if (username == null) {
            LOG.warn((Object)"No or empty username found in request");
            context.getEvent().error("user_not_found");
            Response challengeResponse = this.challenge(context, this.getDefaultChallengeMessage(context), "username");
            context.failureChallenge(AuthenticationFlowError.INVALID_USER, challengeResponse);
            return null;
        }
        LOG.debugf("Found username '%s' in request", (Object)username);
        context.getEvent().detail("username", username);
        context.getAuthenticationSession().setAuthNote("ATTEMPTED_USERNAME", username);
        context.getAuthenticationSession().setClientNote("login_hint", username);
        try {
            UserModel user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)context.getSession(), (RealmModel)context.getRealm(), (String)username);
            if (user != null) {
                LOG.tracef("Setting user '%s' in context", (Object)user.getId());
                context.setUser(user);
            }
        }
        catch (ModelDuplicateException ex) {
            LOG.warnf((Throwable)ex, "Could not uniquely identify the user. Multiple users with name or email '%s' found.", (Object)username);
        }
        return username;
    }

    private String trimToNull(String username) {
        if (username != null && "".equalsIgnoreCase(username = username.trim())) {
            username = null;
        }
        return username;
    }

    protected Response createLoginForm(LoginFormsProvider form) {
        return form.createLoginUsername();
    }

    protected String getDefaultChallengeMessage(AuthenticationFlowContext context) {
        return context.getRealm().isLoginWithEmailAllowed() ? "invalidUsernameOrEmailMessage" : "invalidUsernameMessage";
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }
}

