/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth.idp;

import com.google.auto.service.AutoService;
import io.phasetwo.service.auth.idp.HomeIdpDiscoveryAuthenticator;
import io.phasetwo.service.auth.idp.HomeIdpDiscoveryConfigProperties;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ServerInfoAwareProviderFactory;

@AutoService(value={AuthenticatorFactory.class})
public final class HomeIdpDiscoveryAuthenticatorFactory
implements AuthenticatorFactory,
ServerInfoAwareProviderFactory {
    private static final Logger LOG = Logger.getLogger(HomeIdpDiscoveryAuthenticatorFactory.class);
    private static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.ALTERNATIVE, AuthenticationExecutionModel.Requirement.DISABLED};
    private static final String PROVIDER_ID = "ext-auth-home-idp-discovery";
    private Config.Scope config;

    public String getDisplayType() {
        return "Home IdP Discovery";
    }

    public String getReferenceCategory() {
        return "Authorization";
    }

    public boolean isConfigurable() {
        return true;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return "Redirects users to their home identity provider";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return HomeIdpDiscoveryConfigProperties.CONFIG_PROPERTIES;
    }

    public Authenticator create(KeycloakSession session) {
        return new HomeIdpDiscoveryAuthenticator();
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public Map<String, String> getOperationalInfo() {
        String version = this.getClass().getPackage().getImplementationVersion();
        if (version == null) {
            version = "dev-snapshot";
        }
        return Map.of("Version", version);
    }
}

