/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth.idp;

import io.phasetwo.service.auth.idp.Domain;
import java.util.Arrays;
import java.util.stream.Stream;
import org.keycloak.models.Constants;
import org.keycloak.models.IdentityProviderModel;

final class IdentityProviderModelConfig {
    private static final String DOMAINS_ATTRIBUTE_KEY = "home.idp.discovery.domains";
    private static final String SUBDOMAINS_ATTRIBUTE_KEY = "home.idp.discovery.matchSubdomains";
    private final IdentityProviderModel identityProviderModel;

    IdentityProviderModelConfig(IdentityProviderModel identityProviderModel) {
        this.identityProviderModel = identityProviderModel;
    }

    boolean supportsDomain(String userAttributeName, Domain domain) {
        boolean shouldMatchSubdomains = this.shouldMatchSubdomains(userAttributeName);
        return this.getDomains(userAttributeName).anyMatch(it -> it.equals(domain) || shouldMatchSubdomains && domain.isSubDomainOf((Domain)it));
    }

    private boolean shouldMatchSubdomains(String userAttributeName) {
        String key = this.getSubdomainConfigKey(userAttributeName);
        return Boolean.parseBoolean(this.identityProviderModel.getConfig().getOrDefault(key, "false"));
    }

    private Stream<Domain> getDomains(String userAttributeName) {
        String key = this.getDomainConfigKey(userAttributeName);
        String domainsAttribute = this.identityProviderModel.getConfig().getOrDefault(key, "");
        return Arrays.stream(Constants.CFG_DELIMITER_PATTERN.split(domainsAttribute)).map(Domain::new);
    }

    private String getDomainConfigKey(String userAttributeName) {
        return this.getConfigKey(DOMAINS_ATTRIBUTE_KEY, userAttributeName);
    }

    private String getSubdomainConfigKey(String userAttributeName) {
        return this.getConfigKey(SUBDOMAINS_ATTRIBUTE_KEY, userAttributeName);
    }

    private String getConfigKey(String attributeKey, String userAttributeName) {
        Object key = attributeKey;
        if (userAttributeName != null) {
            String candidateKey = attributeKey + "." + userAttributeName;
            if (this.identityProviderModel.getConfig().containsKey(candidateKey)) {
                key = candidateKey;
            }
        }
        return key;
    }
}

