/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth.idp;

import io.phasetwo.service.auth.idp.Redirector;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class IdpSelectorAuthenticator
implements Authenticator {
    private static final Logger log = Logger.getLogger(IdpSelectorAuthenticator.class);
    protected static final String ACCEPTS_PROMPT_NONE = "acceptsPromptNoneForwardFromClient";
    private final KeycloakSession session;

    public IdpSelectorAuthenticator(KeycloakSession session) {
        this.session = session;
    }

    public void authenticate(AuthenticationFlowContext context) {
        Response challenge = context.form().createForm("login-select-idp.ftl");
        context.challenge(challenge);
    }

    private void redirect(AuthenticationFlowContext context, String providerId) {
        IdentityProviderModel identityProvider = context.getRealm().getIdentityProviderByAlias(providerId);
        if (identityProvider != null && identityProvider.isEnabled()) {
            new Redirector(context).redirectTo(identityProvider);
            return;
        }
        log.warnf("Provider not found or not enabled for realm %s", (Object)providerId);
        if (context.getExecution().getRequirement() == AuthenticationExecutionModel.Requirement.REQUIRED) {
            context.success();
        } else {
            context.attempted();
        }
    }

    public void action(AuthenticationFlowContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String providerId = (String)formData.getFirst((Object)"providerId");
        log.infof("Redirecting to %s", (Object)providerId);
        this.redirect(context, providerId);
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

