/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth.idp;

import com.google.auto.service.AutoService;
import io.phasetwo.service.auth.idp.IdpSelectorAuthenticator;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.ConfigurableAuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

@AutoService(value={AuthenticatorFactory.class})
public class IdpSelectorAuthenticatorFactory
implements AuthenticatorFactory,
ConfigurableAuthenticatorFactory {
    private static final Logger log = Logger.getLogger(IdpSelectorAuthenticatorFactory.class);
    public static final String PROVIDER_ID = "ext-auth-idp-selector";
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.ALTERNATIVE, AuthenticationExecutionModel.Requirement.DISABLED};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getId() {
        return PROVIDER_ID;
    }

    public Authenticator create(KeycloakSession session) {
        return new IdpSelectorAuthenticator(session);
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public boolean isConfigurable() {
        return false;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getHelpText() {
        return "Allows a user to select an IdP by alias and be redirected.";
    }

    public String getDisplayType() {
        return "IdP Selector";
    }

    public String getReferenceCategory() {
        return null;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }
}

