/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth.idp;

import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.sessions.AuthenticationSessionModel;

final class LoginHint {
    private final AuthenticationFlowContext context;

    LoginHint(AuthenticationFlowContext context) {
        this.context = context;
    }

    void setInAuthSession(IdentityProviderModel homeIdp, String defaultUsername) {
        if (homeIdp == null) {
            return;
        }
        UserModel user = this.context.getUser();
        if (user != null) {
            Map<String, String> idpToUsername = this.context.getSession().users().getFederatedIdentitiesStream(this.context.getRealm(), user).collect(Collectors.toMap(FederatedIdentityModel::getIdentityProvider, FederatedIdentityModel::getUserName));
            String loginHint = idpToUsername.getOrDefault(homeIdp.getAlias(), defaultUsername);
            this.context.getAuthenticationSession().setClientNote("login_hint", loginHint);
        }
    }

    String getFromSession() {
        return this.context.getAuthenticationSession().getClientNote("login_hint");
    }

    void copyTo(ClientSessionCode<AuthenticationSessionModel> clientSessionCode) {
        String loginHint = this.getFromSession();
        if (clientSessionCode.getClientSession() != null && loginHint != null) {
            ((AuthenticationSessionModel)clientSessionCode.getClientSession()).setClientNote("login_hint", loginHint);
        }
    }
}

