/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth.invitation;

import io.phasetwo.service.model.OrganizationProvider;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class InvitationAuthenticator
implements Authenticator {
    private static final Logger log = Logger.getLogger(InvitationAuthenticator.class);

    public void authenticate(AuthenticationFlowContext context) {
        log.info((Object)"InvitationAuthenticator.authenticate called");
        context.success();
    }

    public void action(AuthenticationFlowContext context) {
        log.info((Object)"InvitationAuthenticator.action called");
        context.attempted();
    }

    public boolean requiresUser() {
        return true;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        log.infof("InvitationAuthenticator.configuredFor called for realm %s and user %s", (Object)realm.getName(), (Object)user.getEmail());
        OrganizationProvider orgs = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
        long cnt = orgs.getUserInvitationsStream(realm, user).count();
        log.infof("Found %d invites for %s", (Object)cnt, (Object)user.getEmail());
        return cnt <= 0L;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
        log.infof("InvitationAuthenticator.setRequiredActions called for realm %s and user %s", (Object)realm.getName(), (Object)user.getEmail());
        user.addRequiredAction("invitation-required-action");
    }

    public void close() {
    }
}

