/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth.invitation;

import com.google.auto.service.AutoService;
import io.phasetwo.service.auth.invitation.InvitationAuthenticator;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.ConfigurableAuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;

@AutoService(value={AuthenticatorFactory.class})
public class InvitationAuthenticatorFactory
implements AuthenticatorFactory,
ConfigurableAuthenticatorFactory {
    private static final Logger log = Logger.getLogger(InvitationAuthenticatorFactory.class);
    public static final String PROVIDER_ID = "invitation-authenticator";
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getId() {
        return PROVIDER_ID;
    }

    public Authenticator create(KeycloakSession session) {
        return new InvitationAuthenticator();
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return true;
    }

    public boolean isConfigurable() {
        return false;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getHelpText() {
        return "Checks for outstanding organization invitations for the user.";
    }

    public String getDisplayType() {
        return "Invitation";
    }

    public String getReferenceCategory() {
        return "Invitation";
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }
}

