/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.auth.invitation;

import io.phasetwo.service.auth.invitation.InvitationsBean;
import io.phasetwo.service.model.InvitationModel;
import io.phasetwo.service.model.OrganizationProvider;
import io.phasetwo.service.model.OrganizationRoleModel;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class InvitationRequiredAction
implements RequiredActionProvider {
    private static final Logger log = Logger.getLogger(InvitationRequiredAction.class);

    public void evaluateTriggers(RequiredActionContext context) {
        RealmModel realm = context.getRealm();
        UserModel user = context.getUser();
        log.debugf("InvitationRequiredAction.evaluateTriggers called for realm %s and user %s", (Object)realm.getName(), (Object)user.getEmail());
        long cnt = this.getUserInvites(context, realm, user).count();
        log.debugf("Found %d invites for %s", cnt, (Object)user.getEmail());
        if (cnt > 0L) {
            log.debugf("Adding InvitationRequiredActionFactory for %s", (Object)user.getEmail());
            user.addRequiredAction("invitation-required-action");
        }
    }

    private Stream<InvitationModel> getUserInvites(RequiredActionContext context, RealmModel realm, UserModel user) {
        OrganizationProvider orgs = (OrganizationProvider)context.getSession().getProvider(OrganizationProvider.class);
        return orgs.getUserInvitationsStream(realm, user);
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        List<InvitationModel> invites;
        RealmModel realm = context.getRealm();
        UserModel user = context.getUser();
        OrganizationProvider orgs = (OrganizationProvider)context.getSession().getProvider(OrganizationProvider.class);
        log.infof("InvitationRequiredAction.requiredActionChallenge called for realm %s and user %s", (Object)realm.getName(), (Object)user.getEmail());
        if (user.isEmailVerified() && user.getEmail() != null && (invites = this.getUserInvites(context, realm, user).collect(Collectors.toList())) != null && invites.size() > 0) {
            log.infof("Found %d invites for %s", (Object)invites.size(), (Object)user.getEmail());
            InvitationsBean ib = new InvitationsBean(realm, invites);
            Response challenge = context.form().setAttribute("invitations", (Object)ib).createForm("invitations.ftl");
            context.challenge(challenge);
            return;
        }
        log.info((Object)"No challenge");
        context.ignore();
    }

    public void processAction(RequiredActionContext context) {
        EventBuilder event = context.getEvent();
        RealmModel realm = context.getRealm();
        UserModel user = context.getUser();
        log.infof("InvitationRequiredAction.processAction called for realm %s and user %s", (Object)realm.getName(), (Object)user.getEmail());
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        log.infof("Form Parameters: %s", (Object)this.mapToString((Map<?, ?>)formData));
        OrganizationProvider orgs = (OrganizationProvider)context.getSession().getProvider(OrganizationProvider.class);
        List selected = (List)formData.get((Object)"orgs");
        orgs.getUserInvitationsStream(realm, user).forEach(i -> {
            if (selected != null && selected.contains(i.getOrganization().getId())) {
                log.infof("selected %s", (Object)i.getOrganization().getId());
                this.memberFromInvitation((InvitationModel)i, user);
                event.clone().event(EventType.CUSTOM_REQUIRED_ACTION).user(user).detail("org_id", i.getOrganization().getId()).detail("invitation_id", i.getId()).success();
            }
            i.getOrganization().revokeInvitation(i.getId());
            event.clone().event(EventType.CUSTOM_REQUIRED_ACTION).detail("org_id", i.getOrganization().getId()).detail("invitation_id", i.getId()).user(user).error("User invitation revoked.");
        });
        context.success();
    }

    void memberFromInvitation(InvitationModel invitation, UserModel user) {
        invitation.getOrganization().grantMembership(user);
        invitation.getRoles().stream().forEach(r -> {
            OrganizationRoleModel role = invitation.getOrganization().getRoleByName((String)r);
            if (role == null) {
                log.debugf("No org role found for invitation role %s. Skipping...", r);
            } else {
                role.grantRole(user);
            }
        });
    }

    public void close() {
    }

    private String mapToString(Map<?, ?> map) {
        return map.keySet().stream().map(key -> String.valueOf(key) + "=" + String.valueOf(map.get(key))).collect(Collectors.joining(", ", "{", "}"));
    }
}

