/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.importexport;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.phasetwo.service.importexport.representation.InvitationRepresentation;
import io.phasetwo.service.importexport.representation.OrganizationAttributes;
import io.phasetwo.service.importexport.representation.OrganizationRepresentation;
import io.phasetwo.service.importexport.representation.OrganizationRoleRepresentation;
import io.phasetwo.service.importexport.representation.UserRolesRepresentation;
import io.phasetwo.service.model.InvitationModel;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationRoleModel;
import io.phasetwo.service.resource.OrganizationResourceProviderFactory;
import io.phasetwo.service.util.IdentityProviders;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.UserModel;

public final class KeycloakOrgsExportConverter {
    public static OrganizationRepresentation convertOrganizationModelToOrganizationRepresentation(OrganizationModel organizationModel, boolean exportMembersAndInvitations) {
        OrganizationAttributes organization = KeycloakOrgsExportConverter.convertOrganizationModelToOrganizationAttributes(organizationModel);
        List<OrganizationRoleRepresentation> roles = organizationModel.getRolesStream().map(KeycloakOrgsExportConverter::convertOrganizationRoleRepresentation).toList();
        Optional<String> idpOptional = organizationModel.getIdentityProvidersStream().filter(identityProviderModel -> KeycloakOrgsExportConverter.idpInOrg(identityProviderModel, organizationModel.getId())).map(IdentityProviderModel::getAlias).findFirst();
        OrganizationRepresentation organizationRepresentation = new OrganizationRepresentation();
        organizationRepresentation.setOrganization(organization);
        organizationRepresentation.setRoles(roles);
        idpOptional.ifPresent(organizationRepresentation::setIdpLink);
        if (exportMembersAndInvitations) {
            List<UserRolesRepresentation> members = organizationModel.getMembersStream().filter(userModel -> !OrganizationResourceProviderFactory.getDefaultAdminUsername(organizationModel).contains(userModel.getUsername())).map(userModel -> {
                List<String> userRoles = organizationModel.getRolesByUserStream((UserModel)userModel).map(OrganizationRoleModel::getName).toList();
                return new UserRolesRepresentation(userModel.getUsername(), userRoles);
            }).toList();
            organizationRepresentation.setMembers(members);
            List<InvitationRepresentation> invitations = organizationModel.getInvitationsStream().map(KeycloakOrgsExportConverter::convertInvitationModelToInvitationRepresentation).toList();
            organizationRepresentation.setInvitations(invitations);
        }
        return organizationRepresentation;
    }

    private static InvitationRepresentation convertInvitationModelToInvitationRepresentation(InvitationModel invitationModel) {
        InvitationRepresentation i = new InvitationRepresentation();
        i.setEmail(invitationModel.getEmail());
        i.setInviterUsername(invitationModel.getInviter().getUsername());
        i.setRedirectUri(invitationModel.getUrl());
        i.setRoles(Lists.newArrayList(invitationModel.getRoles()));
        i.setAttributes(Maps.newHashMap(invitationModel.getAttributes()));
        return i;
    }

    private static OrganizationRoleRepresentation convertOrganizationRoleRepresentation(OrganizationRoleModel m) {
        OrganizationRoleRepresentation role = new OrganizationRoleRepresentation();
        role.setName(m.getName());
        role.setDescription(m.getDescription());
        return role;
    }

    private static OrganizationAttributes convertOrganizationModelToOrganizationAttributes(OrganizationModel e) {
        OrganizationAttributes o = new OrganizationAttributes();
        o.setName(e.getName());
        o.setDisplayName(e.getDisplayName());
        o.setDomains(e.getDomains());
        o.setUrl(e.getUrl());
        o.setAttributes(e.getAttributes());
        return o;
    }

    private static boolean idpInOrg(IdentityProviderModel provider, String orgId) {
        Set<String> orgs = IdentityProviders.getAttributeMultivalued(provider.getConfig(), "home.idp.discovery.org");
        return orgs.contains(orgId);
    }
}

