/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.importexport;

import io.phasetwo.service.importexport.representation.OrganizationAttributes;
import io.phasetwo.service.importexport.representation.OrganizationRepresentation;
import io.phasetwo.service.importexport.representation.OrganizationRoleRepresentation;
import io.phasetwo.service.model.InvitationModel;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationRoleModel;
import io.phasetwo.service.resource.OrganizationAdminAuth;
import io.phasetwo.service.util.IdentityProviders;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public final class KeycloakOrgsImportConverter {
    private static final Logger log = Logger.getLogger(KeycloakOrgsImportConverter.class);

    public static void setOrganizationAttributes(OrganizationAttributes organizationAttributes, OrganizationModel org) {
        org.setDisplayName(organizationAttributes.getDisplayName());
        org.setUrl(organizationAttributes.getUrl());
        if (organizationAttributes.getAttributes() != null) {
            organizationAttributes.getAttributes().forEach(org::setAttribute);
        }
        if (organizationAttributes.getDomains() != null) {
            org.setDomains(organizationAttributes.getDomains());
        }
    }

    public static void addInvitations(KeycloakSession session, RealmModel newRealm, OrganizationRepresentation organizationRepresentation, OrganizationModel org, boolean skipMissingMember) {
        organizationRepresentation.getInvitations().forEach(invitation -> {
            UserModel user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)session, (RealmModel)newRealm, (String)invitation.getEmail());
            if (user != null && org.hasMembership(user)) {
                throw new ModelException("User with email %s s already a member of organization: %s ".formatted(invitation.getEmail(), org.getName()));
            }
            UserModel inviter = session.users().getUserByUsername(newRealm, invitation.getInviterUsername());
            if (inviter != null && org.hasMembership(inviter)) {
                InvitationModel i = org.addInvitation(invitation.getEmail(), inviter);
                i.setUrl(invitation.getRedirectUri());
                if (invitation.getRoles() != null) {
                    i.setRoles(invitation.getRoles());
                }
                if (invitation.getAttributes() != null && !invitation.getAttributes().isEmpty()) {
                    invitation.getAttributes().forEach(i::setAttribute);
                }
            } else if (skipMissingMember) {
                log.info((Object)"Skipped invitation import for email: %s. Inviter with username %s not found.".formatted(invitation.getEmail(), invitation.getInviterUsername()));
            } else {
                throw new ModelException("No inviter user with username %s in organization: %s".formatted(invitation.getInviterUsername(), org.getName()));
            }
        });
    }

    public static void addMembers(KeycloakSession session, RealmModel newRealm, OrganizationRepresentation organizationRepresentation, OrganizationModel org, boolean skipMissingMember) {
        organizationRepresentation.getMembers().forEach(member -> {
            UserModel userModel = session.users().getUserByUsername(newRealm, member.getUsername());
            if (Objects.nonNull(userModel)) {
                org.grantMembership(userModel);
                member.getRoles().stream().map(org::getRoleByName).forEach(organizationRoleModel -> organizationRoleModel.grantRole(userModel));
            } else if (skipMissingMember) {
                log.info((Object)("Skipped import for member with username: " + member.getUsername() + ". No user found."));
            } else {
                throw new ModelException("No user with username: " + member.getUsername());
            }
        });
    }

    public static void createOrganizationIdp(RealmModel realm, String idpLink, OrganizationModel org, boolean skipMissingIdp) {
        if (Objects.nonNull(idpLink)) {
            IdentityProviderModel idp = realm.getIdentityProviderByAlias(idpLink);
            if (Objects.nonNull(idp)) {
                IdentityProviders.setAttributeMultivalued(idp.getConfig(), "home.idp.discovery.org", Set.of(org.getId()));
                realm.updateIdentityProvider(idp);
            } else if (skipMissingIdp) {
                log.info((Object)("Skipped import for idp with alias: " + idpLink + ". No identity provider config found."));
            } else {
                throw new ModelException("No identity provider config with alias: " + idpLink);
            }
        }
    }

    public static void createOrganizationRoles(List<OrganizationRoleRepresentation> roles, OrganizationModel org) {
        roles.stream().filter(organizationRole -> Arrays.stream(OrganizationAdminAuth.DEFAULT_ORG_ROLES).noneMatch(role -> role.equals(organizationRole.getName()))).forEach(organizationRole -> {
            OrganizationRoleModel role = org.addRole(organizationRole.getName());
            role.setDescription(organizationRole.getDescription());
        });
    }
}

