/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.model;

import com.google.common.collect.MoreCollectors;
import io.phasetwo.service.model.DomainModel;
import io.phasetwo.service.model.InvitationModel;
import io.phasetwo.service.model.OrganizationRoleModel;
import io.phasetwo.service.model.WithAttributes;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderEvent;

public interface OrganizationModel
extends WithAttributes {
    public String getId();

    public String getName();

    public void setName(String var1);

    public String getDisplayName();

    public void setDisplayName(String var1);

    public Set<String> getDomains();

    public void setDomains(Set<String> var1);

    public DomainModel getDomain(String var1);

    public String getUrl();

    public void setUrl(String var1);

    public RealmModel getRealm();

    public UserModel getCreatedBy();

    public Long getMembersCount();

    public Stream<UserModel> getMembersStream();

    public Stream<UserModel> searchForMembersStream(String var1, Integer var2, Integer var3);

    public boolean hasMembership(UserModel var1);

    public void grantMembership(UserModel var1);

    public void revokeMembership(UserModel var1);

    public Long getInvitationsCount();

    public Stream<InvitationModel> getInvitationsStream();

    default public Stream<InvitationModel> getInvitationsByEmail(String email) {
        return this.getInvitationsStream().filter(i -> i.getEmail().equals(email));
    }

    public InvitationModel getInvitation(String var1);

    public void revokeInvitation(String var1);

    public void revokeInvitations(String var1);

    public InvitationModel addInvitation(String var1, UserModel var2);

    public Stream<OrganizationRoleModel> getRolesStream();

    public Stream<OrganizationRoleModel> getRolesByUserStream(UserModel var1);

    default public OrganizationRoleModel getRoleByName(String name) {
        return ((Optional)this.getRolesStream().filter(r -> name.equals(r.getName())).collect(MoreCollectors.toOptional())).orElse(null);
    }

    public void removeRole(String var1);

    public OrganizationRoleModel addRole(String var1);

    public Stream<IdentityProviderModel> getIdentityProvidersStream();

    public static interface OrganizationRemovedEvent
    extends OrganizationEvent {
    }

    public static interface OrganizationCreationEvent
    extends OrganizationEvent {
    }

    public static interface OrganizationEvent
    extends ProviderEvent {
        public OrganizationModel getOrganization();

        public KeycloakSession getKeycloakSession();

        public RealmModel getRealm();
    }
}

