/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.model;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import io.phasetwo.service.model.InvitationModel;
import io.phasetwo.service.model.OrganizationModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.Provider;

public interface OrganizationProvider
extends Provider {
    public OrganizationModel createOrganization(RealmModel var1, String var2, UserModel var3, boolean var4);

    public OrganizationModel getOrganizationById(RealmModel var1, String var2);

    public Stream<OrganizationModel> getOrganizationsStreamForDomain(RealmModel var1, String var2, boolean var3);

    public Stream<OrganizationModel> getUserOrganizationsStream(RealmModel var1, UserModel var2);

    public Stream<OrganizationModel> searchForOrganizationStream(RealmModel var1, Map<String, String> var2, Integer var3, Integer var4, Optional<UserModel> var5);

    public Long getOrganizationsCount(RealmModel var1, String var2);

    public boolean removeOrganization(RealmModel var1, String var2);

    public void removeOrganizations(RealmModel var1);

    public Stream<InvitationModel> getUserInvitationsStream(RealmModel var1, UserModel var2);

    @Deprecated(forRemoval=true)
    default public Stream<OrganizationModel> searchForOrganizationByNameStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        HashMap attributes = Maps.newHashMap();
        if (!Strings.isNullOrEmpty((String)search)) {
            attributes.put("name", search);
        }
        return this.searchForOrganizationStream(realm, attributes, firstResult, maxResults, Optional.empty());
    }

    @Deprecated(forRemoval=true)
    default public Stream<OrganizationModel> searchForOrganizationByAttributesStream(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        return this.searchForOrganizationStream(realm, attributes, firstResult, maxResults, Optional.empty());
    }

    @Deprecated(forRemoval=true)
    default public Stream<OrganizationModel> getOrganizationsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        return this.searchForOrganizationStream(realm, null, firstResult, maxResults, Optional.empty());
    }

    @Deprecated(forRemoval=true)
    default public Stream<OrganizationModel> getOrganizationsStream(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        return this.searchForOrganizationStream(realm, attributes, firstResult, maxResults, Optional.empty());
    }

    @Deprecated(forRemoval=true)
    default public Stream<OrganizationModel> getOrganizationsStream(RealmModel realm) {
        return this.searchForOrganizationStream(realm, null, null, null, Optional.empty());
    }
}

