/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.model.jpa;

import io.phasetwo.service.model.DomainModel;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationProvider;
import io.phasetwo.service.model.jpa.entity.DomainEntity;
import jakarta.persistence.EntityManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.jpa.JpaModel;

public class DomainAdapter
implements DomainModel,
JpaModel<DomainEntity> {
    protected final KeycloakSession session;
    protected final DomainEntity domain;
    protected final EntityManager em;
    protected final RealmModel realm;

    public DomainAdapter(KeycloakSession session, RealmModel realm, EntityManager em, DomainEntity domain) {
        this.session = session;
        this.em = em;
        this.domain = domain;
        this.realm = realm;
    }

    public DomainEntity getEntity() {
        return this.domain;
    }

    @Override
    public OrganizationModel getOrganization() {
        return ((OrganizationProvider)this.session.getProvider(OrganizationProvider.class)).getOrganizationById(this.realm, this.domain.getOrganization().getId());
    }

    @Override
    public String getDomain() {
        return this.domain.getDomain();
    }

    @Override
    public boolean isVerified() {
        return this.domain.isVerified();
    }

    @Override
    public void setVerified(boolean verified) {
        this.domain.setVerified(verified);
    }
}

