/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.model.jpa;

import com.google.common.collect.Sets;
import io.phasetwo.service.model.InvitationModel;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationProvider;
import io.phasetwo.service.model.jpa.entity.InvitationAttributeEntity;
import io.phasetwo.service.model.jpa.entity.InvitationEntity;
import jakarta.persistence.EntityManager;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class InvitationAdapter
implements InvitationModel,
JpaModel<InvitationEntity> {
    protected final KeycloakSession session;
    protected final InvitationEntity invitation;
    protected final EntityManager em;
    protected final RealmModel realm;

    public InvitationAdapter(KeycloakSession session, RealmModel realm, EntityManager em, InvitationEntity invitation) {
        this.session = session;
        this.em = em;
        this.invitation = invitation;
        this.realm = realm;
    }

    public InvitationEntity getEntity() {
        return this.invitation;
    }

    @Override
    public String getId() {
        return this.invitation.getId();
    }

    @Override
    public OrganizationModel getOrganization() {
        return ((OrganizationProvider)this.session.getProvider(OrganizationProvider.class)).getOrganizationById(this.realm, this.invitation.getOrganization().getId());
    }

    @Override
    public String getEmail() {
        return this.invitation.getEmail();
    }

    @Override
    public void setEmail(String email) {
        this.invitation.setEmail(email);
    }

    @Override
    public String getUrl() {
        return this.invitation.getUrl();
    }

    @Override
    public void setUrl(String url) {
        this.invitation.setUrl(url);
    }

    @Override
    public UserModel getInviter() {
        if (this.invitation.getInviterId() != null) {
            UserModel inviter = this.session.users().getUserById(this.realm, this.invitation.getInviterId());
            if (inviter != null) {
                return inviter;
            }
            this.invitation.setInviterId(null);
        }
        return null;
    }

    @Override
    public void setInviter(UserModel inviter) {
        this.invitation.setInviterId(inviter.getId());
    }

    @Override
    public Date getCreatedAt() {
        return this.invitation.getCreatedAt();
    }

    @Override
    public void setCreatedAt(Date date) {
        this.invitation.setCreatedAt(date);
    }

    @Override
    public Set<String> getRoles() {
        return this.invitation.getRoles();
    }

    @Override
    public void setRoles(Collection<String> roles) {
        this.invitation.setRoles(Sets.newHashSet(roles));
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        MultivaluedHashMap result = new MultivaluedHashMap();
        for (InvitationAttributeEntity attr : this.invitation.getAttributes()) {
            result.add((Object)attr.getName(), (Object)attr.getValue());
        }
        return result;
    }

    @Override
    public void removeAttribute(String name) {
        this.invitation.getAttributes().removeIf(attribute -> attribute.getName().equals(name));
    }

    @Override
    public void removeAttributes() {
        this.invitation.getAttributes().clear();
    }

    @Override
    public void setAttribute(String name, List<String> values) {
        this.removeAttribute(name);
        for (String value : values) {
            InvitationAttributeEntity a = new InvitationAttributeEntity();
            a.setId(KeycloakModelUtils.generateId());
            a.setName(name);
            a.setValue(value);
            a.setInvitation(this.invitation);
            this.em.persist((Object)a);
            this.invitation.getAttributes().add(a);
        }
    }
}

