/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.model.jpa;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.InternetDomainName;
import io.phasetwo.service.model.InvitationModel;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationProvider;
import io.phasetwo.service.model.jpa.InvitationAdapter;
import io.phasetwo.service.model.jpa.OrganizationAdapter;
import io.phasetwo.service.model.jpa.entity.DomainEntity;
import io.phasetwo.service.model.jpa.entity.ExtOrganizationEntity;
import io.phasetwo.service.model.jpa.entity.InvitationEntity;
import io.phasetwo.service.model.jpa.entity.OrganizationMemberEntity;
import io.phasetwo.service.resource.OrganizationAdminAuth;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.utils.StreamsUtil;

public class JpaOrganizationProvider
implements OrganizationProvider {
    protected final KeycloakSession session;
    protected final EntityManager em;

    public JpaOrganizationProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
    }

    @Override
    public OrganizationModel createOrganization(RealmModel realm, String name, UserModel createdBy, boolean admin) {
        ExtOrganizationEntity e = new ExtOrganizationEntity();
        e.setId(KeycloakModelUtils.generateId());
        e.setRealmId(realm.getId());
        e.setName(name);
        e.setCreatedBy(createdBy.getId());
        this.em.persist((Object)e);
        this.em.flush();
        OrganizationAdapter org = new OrganizationAdapter(this.session, realm, this.em, e);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)this.orgCreationEvent(realm, org));
        if (admin && createdBy.getServiceAccountClientLink() == null) {
            org.grantMembership(createdBy);
            for (String role : OrganizationAdminAuth.DEFAULT_ORG_ROLES) {
                org.getRoleByName(role).grantRole(createdBy);
            }
        }
        return org;
    }

    @Override
    public OrganizationModel getOrganizationById(RealmModel realm, String id) {
        ExtOrganizationEntity org = (ExtOrganizationEntity)this.em.find(ExtOrganizationEntity.class, (Object)id);
        if (org != null && org.getRealmId().equals(realm.getId())) {
            return new OrganizationAdapter(this.session, realm, this.em, org);
        }
        return null;
    }

    @Override
    public Stream<OrganizationModel> getOrganizationsStreamForDomain(RealmModel realm, String domain, boolean verified) {
        domain = InternetDomainName.from((String)domain).toString();
        TypedQuery query = this.em.createNamedQuery(verified ? "getVerifiedDomainsByName" : "getDomainsByName", DomainEntity.class);
        query.setParameter("domain", (Object)domain);
        query.setParameter("realmId", (Object)realm.getId());
        if (verified) {
            query.setParameter("verified", (Object)verified);
        }
        return query.getResultStream().map(de -> new OrganizationAdapter(this.session, realm, this.em, de.getOrganization()));
    }

    public static String createSearchString(String search) {
        if (Strings.isNullOrEmpty((String)search)) {
            return "%";
        }
        if (!((String)search).startsWith("%")) {
            search = "%" + (String)search;
        }
        if (!((String)search).endsWith("%")) {
            search = (String)search + "%";
        }
        return search;
    }

    @Override
    public Stream<OrganizationModel> getUserOrganizationsStream(RealmModel realm, UserModel user) {
        TypedQuery query = this.em.createNamedQuery("getOrganizationMembershipsByUserId", OrganizationMemberEntity.class);
        query.setParameter("id", (Object)user.getId());
        return query.getResultStream().map(e -> new OrganizationAdapter(this.session, realm, this.em, e.getOrganization()));
    }

    @Override
    public Stream<OrganizationModel> searchForOrganizationStream(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults, Optional<UserModel> member) {
        if (attributes == null) {
            attributes = ImmutableMap.of();
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(ExtOrganizationEntity.class);
        Root root = queryBuilder.from(ExtOrganizationEntity.class);
        List<Predicate> predicates = this.attributePredicates((Map<String, String>)attributes, (Root<ExtOrganizationEntity>)root);
        predicates.add(builder.equal((Expression)root.get("realmId"), (Object)realm.getId()));
        member.ifPresent(u -> predicates.add(this.memberPredicate((UserModel)u, (Root<ExtOrganizationEntity>)root)));
        queryBuilder.where(predicates.toArray(new Predicate[0])).orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        TypedQuery query = this.em.createQuery(queryBuilder);
        return StreamsUtil.closing((Stream)PaginationUtils.paginateQuery((TypedQuery)query, (Integer)firstResult, (Integer)maxResults).getResultStream()).map(orgEntity -> this.getOrganizationById(realm, orgEntity.getId())).filter(Objects::nonNull);
    }

    @Override
    public Long getOrganizationsCount(RealmModel realm, String search) {
        TypedQuery query = this.em.createNamedQuery("countOrganizationsByRealmIdAndName", Long.class);
        query.setParameter("realmId", (Object)realm.getId());
        search = JpaOrganizationProvider.createSearchString(search);
        query.setParameter("search", (Object)search);
        return (Long)query.getSingleResult();
    }

    @Override
    public boolean removeOrganization(RealmModel realm, String id) {
        OrganizationModel org = this.getOrganizationById(realm, id);
        ExtOrganizationEntity e = (ExtOrganizationEntity)this.em.find(ExtOrganizationEntity.class, (Object)id);
        this.em.remove((Object)e);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)this.orgRemovedEvent(realm, org));
        this.em.flush();
        return true;
    }

    @Override
    public void removeOrganizations(RealmModel realm) {
        this.searchForOrganizationStream(realm, null, null, null, Optional.empty()).forEach(o -> this.removeOrganization(realm, o.getId()));
    }

    @Override
    public Stream<InvitationModel> getUserInvitationsStream(RealmModel realm, UserModel user) {
        TypedQuery query = this.em.createNamedQuery("getInvitationsByRealmAndEmail", InvitationEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("search", (Object)user.getEmail());
        return query.getResultStream().map(i -> new InvitationAdapter(this.session, realm, this.em, (InvitationEntity)i));
    }

    public void close() {
    }

    public OrganizationModel.OrganizationCreationEvent orgCreationEvent(final RealmModel realm, final OrganizationModel org) {
        return new OrganizationModel.OrganizationCreationEvent(){

            @Override
            public OrganizationModel getOrganization() {
                return org;
            }

            @Override
            public KeycloakSession getKeycloakSession() {
                return JpaOrganizationProvider.this.session;
            }

            @Override
            public RealmModel getRealm() {
                return realm;
            }
        };
    }

    public OrganizationModel.OrganizationRemovedEvent orgRemovedEvent(final RealmModel realm, final OrganizationModel org) {
        return new OrganizationModel.OrganizationRemovedEvent(){

            @Override
            public OrganizationModel getOrganization() {
                return org;
            }

            @Override
            public KeycloakSession getKeycloakSession() {
                return JpaOrganizationProvider.this.session;
            }

            @Override
            public RealmModel getRealm() {
                return realm;
            }
        };
    }

    private List<Predicate> attributePredicates(Map<String, String> attributes, Root<ExtOrganizationEntity> root) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        ArrayList<Predicate> attributePredicates = new ArrayList<Predicate>();
        block6: for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            switch (key) {
                case "name": {
                    predicates.add(builder.or((Expression)builder.like(builder.lower((Expression)root.get("name")), "%" + value.toLowerCase() + "%"), (Expression)builder.like(builder.lower((Expression)root.get("displayName")), "%" + value.toLowerCase() + "%")));
                    continue block6;
                }
            }
            Join attributesJoin = root.join("attributes", JoinType.LEFT);
            attributePredicates.add(builder.and((Expression)builder.equal(builder.lower((Expression)attributesJoin.get("name")), (Object)key.toLowerCase()), (Expression)builder.equal(builder.lower((Expression)attributesJoin.get("value")), (Object)value.toLowerCase())));
        }
        if (!attributePredicates.isEmpty()) {
            predicates.add(builder.and(attributePredicates.toArray(new Predicate[0])));
        }
        return predicates;
    }

    private Predicate memberPredicate(UserModel member, Root<ExtOrganizationEntity> root) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        Join membersJoin = root.join("members", JoinType.LEFT);
        return builder.equal((Expression)membersJoin.get("userId"), (Object)member.getId());
    }
}

