/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.model.jpa;

import com.google.auto.service.AutoService;
import io.phasetwo.service.model.OrganizationProvider;
import io.phasetwo.service.model.OrganizationProviderFactory;
import io.phasetwo.service.model.jpa.JpaOrganizationProvider;
import jakarta.persistence.EntityManager;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

@AutoService(value={OrganizationProviderFactory.class})
public class JpaOrganizationProviderFactory
implements OrganizationProviderFactory {
    private static final Logger log = Logger.getLogger(JpaOrganizationProviderFactory.class);
    public static final String PROVIDER_ID = "jpa-organization";

    public String getId() {
        return PROVIDER_ID;
    }

    public OrganizationProvider create(KeycloakSession session) {
        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        return new JpaOrganizationProvider(session, em);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }
}

