/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.model.jpa;

import com.google.common.base.Strings;
import io.phasetwo.service.model.DomainModel;
import io.phasetwo.service.model.InvitationModel;
import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationRoleModel;
import io.phasetwo.service.model.jpa.DomainAdapter;
import io.phasetwo.service.model.jpa.InvitationAdapter;
import io.phasetwo.service.model.jpa.OrganizationRoleAdapter;
import io.phasetwo.service.model.jpa.entity.DomainEntity;
import io.phasetwo.service.model.jpa.entity.ExtOrganizationEntity;
import io.phasetwo.service.model.jpa.entity.InvitationEntity;
import io.phasetwo.service.model.jpa.entity.OrganizationAttributeEntity;
import io.phasetwo.service.model.jpa.entity.OrganizationMemberEntity;
import io.phasetwo.service.model.jpa.entity.OrganizationRoleEntity;
import io.phasetwo.service.model.jpa.entity.UserOrganizationRoleMappingEntity;
import io.phasetwo.service.util.IdentityProviders;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class OrganizationAdapter
implements OrganizationModel,
JpaModel<ExtOrganizationEntity> {
    protected final KeycloakSession session;
    protected final ExtOrganizationEntity org;
    protected final EntityManager em;
    protected final RealmModel realm;

    public OrganizationAdapter(KeycloakSession session, RealmModel realm, EntityManager em, ExtOrganizationEntity org) {
        this.session = session;
        this.em = em;
        this.org = org;
        this.realm = realm;
    }

    public ExtOrganizationEntity getEntity() {
        return this.org;
    }

    @Override
    public String getId() {
        return this.org.getId();
    }

    @Override
    public String getName() {
        return this.org.getName();
    }

    @Override
    public void setName(String name) {
        this.org.setName(name);
    }

    @Override
    public String getDisplayName() {
        return this.org.getDisplayName();
    }

    @Override
    public void setDisplayName(String displayName) {
        this.org.setDisplayName(displayName);
    }

    @Override
    public Set<String> getDomains() {
        return this.org.getDomains().stream().map(DomainEntity::getDomain).collect(Collectors.toSet());
    }

    @Override
    public void setDomains(Set<String> domains) {
        Set<String> lower = domains.stream().map(d -> d.toLowerCase()).collect(Collectors.toSet());
        this.org.getDomains().removeIf(e -> !lower.contains(e.getDomain()));
        lower.removeIf(d -> this.org.getDomains().stream().filter(e -> d.equals(e.getDomain())).count() > 0L);
        lower.forEach(d -> {
            DomainEntity de = new DomainEntity();
            de.setId(KeycloakModelUtils.generateId());
            de.setDomain((String)d);
            de.setVerified(false);
            de.setOrganization(this.org);
            this.org.getDomains().add(de);
        });
    }

    @Override
    public DomainModel getDomain(String domainName) {
        TypedQuery query = this.em.createNamedQuery("getDomainByOrganizationAndDomainName", DomainEntity.class);
        query.setParameter("organization", (Object)this.org);
        query.setParameter("search", (Object)domainName);
        query.setMaxResults(1);
        try {
            return new DomainAdapter(this.session, this.realm, this.em, (DomainEntity)query.getSingleResult());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getUrl() {
        return this.org.getUrl();
    }

    @Override
    public void setUrl(String url) {
        this.org.setUrl(url);
    }

    @Override
    public RealmModel getRealm() {
        return this.session.realms().getRealm(this.org.getRealmId());
    }

    @Override
    public UserModel getCreatedBy() {
        return this.session.users().getUserById(this.realm, this.org.getCreatedBy());
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        MultivaluedHashMap result = new MultivaluedHashMap();
        for (OrganizationAttributeEntity attr : this.org.getAttributes()) {
            result.add((Object)attr.getName(), (Object)attr.getValue());
        }
        return result;
    }

    @Override
    public void removeAttribute(String name) {
        this.org.getAttributes().removeIf(attribute -> attribute.getName().equals(name));
    }

    @Override
    public void removeAttributes() {
        this.org.getAttributes().clear();
    }

    @Override
    public void setAttribute(String name, List<String> values) {
        this.removeAttribute(name);
        for (String value : values) {
            OrganizationAttributeEntity a = new OrganizationAttributeEntity();
            a.setId(KeycloakModelUtils.generateId());
            a.setName(name);
            a.setValue(value);
            a.setOrganization(this.org);
            this.em.persist((Object)a);
            this.org.getAttributes().add(a);
        }
    }

    @Override
    public Stream<UserModel> searchForMembersStream(String search, Integer firstResult, Integer maxResults) {
        String[] searchTerms = Strings.isNullOrEmpty((String)search) ? new String[]{} : search.split(",");
        return this.getMembersStream().filter(m -> {
            for (String searchTerm : searchTerms) {
                String term = searchTerm.trim().toLowerCase();
                if (term.isEmpty() || !(m.getEmail() != null && m.getEmail().toLowerCase().contains(term) || m.getUsername() != null && m.getUsername().toLowerCase().contains(term) || m.getFirstName() != null && m.getFirstName().toLowerCase().contains(term)) && (m.getLastName() == null || !m.getLastName().toLowerCase().contains(term))) continue;
                return true;
            }
            return searchTerms.length == 0;
        }).skip(firstResult.intValue()).limit(maxResults.intValue());
    }

    @Override
    public Long getMembersCount() {
        TypedQuery query = this.em.createNamedQuery("getOrganizationMembersCount", Long.class);
        query.setParameter("organization", (Object)this.org);
        return (Long)query.getSingleResult();
    }

    @Override
    public Stream<UserModel> getMembersStream() {
        return this.org.getMembers().stream().map(m -> m.getUserId()).map(uid -> this.session.users().getUserById(this.realm, uid)).filter(u -> u != null && u.getServiceAccountClientLink() == null);
    }

    @Override
    public boolean hasMembership(UserModel user) {
        return this.org.getMembers().stream().anyMatch(m -> m.getUserId().equals(user.getId()));
    }

    @Override
    public void grantMembership(UserModel user) {
        if (this.hasMembership(user)) {
            return;
        }
        OrganizationMemberEntity m = new OrganizationMemberEntity();
        m.setId(KeycloakModelUtils.generateId());
        m.setUserId(user.getId());
        m.setOrganization(this.org);
        this.em.persist((Object)m);
        this.org.getMembers().add(m);
    }

    @Override
    public void revokeMembership(UserModel user) {
        if (!this.hasMembership(user)) {
            return;
        }
        this.org.getMembers().removeIf(m -> m.getUserId().equals(user.getId()));
        this.getRolesStream().forEach(r -> r.revokeRole(user));
        if (user.getEmail() != null) {
            this.revokeInvitations(user.getEmail());
        }
    }

    @Override
    public Long getInvitationsCount() {
        TypedQuery query = this.em.createNamedQuery("getInvitationCount", Long.class);
        query.setParameter("organization", (Object)this.org);
        return (Long)query.getSingleResult();
    }

    @Override
    public Stream<InvitationModel> getInvitationsStream() {
        return this.org.getInvitations().stream().map(i -> new InvitationAdapter(this.session, this.realm, this.em, (InvitationEntity)i));
    }

    @Override
    public InvitationModel getInvitation(String id) {
        InvitationEntity ie = (InvitationEntity)this.em.find(InvitationEntity.class, (Object)id);
        if (ie != null && ie.getOrganization().equals(this.org)) {
            return new InvitationAdapter(this.session, this.realm, this.em, ie);
        }
        return null;
    }

    @Override
    public void revokeInvitation(String id) {
        this.org.getInvitations().removeIf(inv -> inv.getId().equals(id));
    }

    @Override
    public void revokeInvitations(String email) {
        this.org.getInvitations().removeIf(inv -> inv.getEmail().equals(email.toLowerCase()));
    }

    @Override
    public InvitationModel addInvitation(String email, UserModel inviter) {
        InvitationEntity inv = new InvitationEntity();
        inv.setId(KeycloakModelUtils.generateId());
        inv.setOrganization(this.org);
        inv.setEmail(email.toLowerCase());
        inv.setInviterId(inviter.getId());
        this.em.persist((Object)inv);
        this.org.getInvitations().add(inv);
        return new InvitationAdapter(this.session, this.realm, this.em, inv);
    }

    @Override
    public Stream<OrganizationRoleModel> getRolesStream() {
        return this.org.getRoles().stream().map(r -> new OrganizationRoleAdapter(this.session, this.realm, this.em, this, (OrganizationRoleEntity)r));
    }

    @Override
    public Stream<OrganizationRoleModel> getRolesByUserStream(UserModel user) {
        TypedQuery query = this.em.createNamedQuery("getMappingsByUser", UserOrganizationRoleMappingEntity.class);
        query.setParameter("userId", (Object)user.getId());
        query.setParameter("orgId", (Object)this.org.getId());
        try {
            return query.getResultStream().map(r -> new OrganizationRoleAdapter(this.session, this.realm, this.em, this, r.getRole()));
        }
        catch (Exception ignore) {
            return null;
        }
    }

    @Override
    public void removeRole(String name) {
        this.org.getRoles().removeIf(r -> r.getName().equals(name));
    }

    @Override
    public OrganizationRoleModel addRole(String name) {
        OrganizationRoleEntity r = new OrganizationRoleEntity();
        r.setId(KeycloakModelUtils.generateId());
        r.setName(name);
        r.setOrganization(this.org);
        this.em.persist((Object)r);
        this.org.getRoles().add(r);
        return new OrganizationRoleAdapter(this.session, this.realm, this.em, this, r);
    }

    @Override
    public Stream<IdentityProviderModel> getIdentityProvidersStream() {
        return this.getRealm().getIdentityProvidersStream().filter(i -> {
            Map config = i.getConfig();
            Set<String> orgs = IdentityProviders.getAttributeMultivalued(config, "home.idp.discovery.org");
            return orgs.contains(this.getId());
        });
    }
}

