/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.model.jpa;

import io.phasetwo.service.model.OrganizationModel;
import io.phasetwo.service.model.OrganizationRoleModel;
import io.phasetwo.service.model.jpa.entity.OrganizationRoleEntity;
import io.phasetwo.service.model.jpa.entity.UserOrganizationRoleMappingEntity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.stream.Stream;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class OrganizationRoleAdapter
implements OrganizationRoleModel,
JpaModel<OrganizationRoleEntity> {
    protected final KeycloakSession session;
    protected final OrganizationRoleEntity role;
    protected final EntityManager em;
    protected final RealmModel realm;
    protected final OrganizationModel org;

    public OrganizationRoleAdapter(KeycloakSession session, RealmModel realm, EntityManager em, OrganizationModel org, OrganizationRoleEntity role) {
        this.session = session;
        this.em = em;
        this.role = role;
        this.realm = realm;
        this.org = org;
    }

    public OrganizationRoleEntity getEntity() {
        return this.role;
    }

    @Override
    public String getId() {
        return this.role.getId();
    }

    @Override
    public String getName() {
        return this.role.getName();
    }

    @Override
    public void setName(String name) {
        this.role.setName(name);
    }

    @Override
    public String getDescription() {
        return this.role.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.role.setDescription(description);
    }

    @Override
    public Stream<UserModel> getUserMappingsStream() {
        return this.role.getUserMappings().stream().map(m -> m.getUserId()).map(uid -> this.session.users().getUserById(this.realm, uid));
    }

    @Override
    public void grantRole(UserModel user) {
        if (!this.org.hasMembership(user)) {
            return;
        }
        if (this.hasRole(user)) {
            return;
        }
        UserOrganizationRoleMappingEntity m = new UserOrganizationRoleMappingEntity();
        m.setId(KeycloakModelUtils.generateId());
        m.setUserId(user.getId());
        m.setRole(this.role);
        this.em.persist((Object)m);
        this.role.getUserMappings().add(m);
    }

    @Override
    public void revokeRole(UserModel user) {
        UserOrganizationRoleMappingEntity e = this.getByUser(user);
        if (e != null) {
            this.role.getUserMappings().remove(e);
            this.em.remove((Object)e);
            this.em.flush();
        }
    }

    @Override
    public boolean hasRole(UserModel user) {
        return this.getByUser(user) != null;
    }

    UserOrganizationRoleMappingEntity getByUser(UserModel user) {
        TypedQuery query = this.em.createNamedQuery("getMappingByRoleAndUser", UserOrganizationRoleMappingEntity.class);
        query.setParameter("userId", (Object)user.getId());
        query.setParameter("role", (Object)this.role);
        try {
            return (UserOrganizationRoleMappingEntity)query.getSingleResult();
        }
        catch (Exception ignore) {
            return null;
        }
    }
}

