/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.model.jpa.entity;

import io.phasetwo.service.model.jpa.entity.ExtOrganizationEntity;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;

@NamedQueries(value={@NamedQuery(name="getDomainsByName", query="SELECT t FROM DomainEntity t WHERE t.domain = :domain AND t.organization.realmId = :realmId"), @NamedQuery(name="getVerifiedDomainsByName", query="SELECT t FROM DomainEntity t WHERE t.domain = :domain AND t.verified = :verified AND t.organization.realmId = :realmId"), @NamedQuery(name="getDomainsByOrganization", query="SELECT t FROM DomainEntity t WHERE t.organization = :organization"), @NamedQuery(name="getDomainByOrganizationAndDomainName", query="SELECT t FROM DomainEntity t WHERE t.organization = :organization AND lower(t.domain) LIKE lower(:search)"), @NamedQuery(name="getDomainCount", query="select count(t) from DomainEntity t where t.organization = :organization")})
@Entity
@Table(name="ORGANIZATION_DOMAIN", uniqueConstraints={@UniqueConstraint(columnNames={"ORGANIZATION_ID", "DOMAIN"})})
public class DomainEntity {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    protected String id;
    @Column(name="DOMAIN")
    protected String domain;
    @Column(name="VERIFIED")
    private boolean verified;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ORGANIZATION_ID")
    private ExtOrganizationEntity organization;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public ExtOrganizationEntity getOrganization() {
        return this.organization;
    }

    public void setOrganization(ExtOrganizationEntity organization) {
        this.organization = organization;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof DomainEntity)) {
            return false;
        }
        DomainEntity that = (DomainEntity)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

