/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.model.jpa.entity;

import io.phasetwo.service.model.jpa.entity.DomainEntity;
import io.phasetwo.service.model.jpa.entity.Entities;
import io.phasetwo.service.model.jpa.entity.InvitationEntity;
import io.phasetwo.service.model.jpa.entity.OrganizationAttributeEntity;
import io.phasetwo.service.model.jpa.entity.OrganizationMemberEntity;
import io.phasetwo.service.model.jpa.entity.OrganizationRoleEntity;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.Collection;
import org.hibernate.annotations.Nationalized;

@NamedQueries(value={@NamedQuery(name="getOrganizationbyRealmIdAndId", query="SELECT o FROM ExtOrganizationEntity o WHERE o.realmId = :realmId AND o.id = :id"), @NamedQuery(name="getOrganizationsByRealmId", query="SELECT o FROM ExtOrganizationEntity o WHERE o.realmId = :realmId"), @NamedQuery(name="getOrganizationsByRealmIdAndName", query="SELECT o FROM ExtOrganizationEntity o WHERE o.realmId = :realmId AND lower(o.name) LIKE lower(:search) ORDER BY o.name"), @NamedQuery(name="countOrganizationsByRealmIdAndName", query="SELECT count(o) FROM ExtOrganizationEntity o WHERE o.realmId = :realmId AND lower(o.name) LIKE lower(:search)"), @NamedQuery(name="getOrganizationCount", query="select count(o) from ExtOrganizationEntity o where o.realmId = :realmId"), @NamedQuery(name="removeAllOrganizations", query="delete from ExtOrganizationEntity o where o.realmId = :realmId")})
@Entity
@Table(name="ORGANIZATION", uniqueConstraints={@UniqueConstraint(columnNames={"REALM_ID", "NAME"})})
public class ExtOrganizationEntity {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    protected String id;
    @Column(name="NAME", nullable=false)
    protected String name;
    @Nationalized
    @Column(name="DISPLAY_NAME")
    protected String displayName;
    @Column(name="URL")
    protected String url;
    @Column(name="REALM_ID", nullable=false)
    protected String realmId;
    @Column(name="CREATED_BY_USER_ID")
    protected String createdBy;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="organization")
    protected Collection<DomainEntity> domains = new ArrayList<DomainEntity>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="organization")
    protected Collection<OrganizationAttributeEntity> attributes = new ArrayList<OrganizationAttributeEntity>();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="organization")
    protected Collection<OrganizationMemberEntity> members = new ArrayList<OrganizationMemberEntity>();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="organization")
    protected Collection<OrganizationRoleEntity> roles = new ArrayList<OrganizationRoleEntity>();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="organization")
    protected Collection<InvitationEntity> invitations = new ArrayList<InvitationEntity>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Collection<DomainEntity> getDomains() {
        return this.domains;
    }

    public void setDomains(Collection<DomainEntity> domains) {
        Entities.setCollection(domains, this.domains);
    }

    public Collection<OrganizationAttributeEntity> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<OrganizationAttributeEntity> attributes) {
        Entities.setCollection(attributes, this.attributes);
    }

    public Collection<OrganizationMemberEntity> getMembers() {
        return this.members;
    }

    public void setMembers(Collection<OrganizationMemberEntity> members) {
        Entities.setCollection(members, this.members);
    }

    public Collection<OrganizationRoleEntity> getRoles() {
        return this.roles;
    }

    public void setRoles(Collection<OrganizationRoleEntity> roles) {
        Entities.setCollection(roles, this.roles);
    }

    public Collection<InvitationEntity> getInvitations() {
        return this.invitations;
    }

    public void setInvitations(Collection<InvitationEntity> invitations) {
        Entities.setCollection(invitations, this.invitations);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ExtOrganizationEntity)) {
            return false;
        }
        ExtOrganizationEntity that = (ExtOrganizationEntity)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

