/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.model.jpa.entity;

import io.phasetwo.service.model.jpa.entity.Entities;
import io.phasetwo.service.model.jpa.entity.ExtOrganizationEntity;
import io.phasetwo.service.model.jpa.entity.InvitationAttributeEntity;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.Email;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

@NamedQueries(value={@NamedQuery(name="getInvitationByOrganization", query="SELECT t FROM InvitationEntity t WHERE t.organization = :organization AND t.id = :id"), @NamedQuery(name="getInvitationsByOrganizationAndEmail", query="SELECT t FROM InvitationEntity t WHERE t.organization = :organization AND lower(t.email) LIKE lower(:search) ORDER BY t.email"), @NamedQuery(name="getInvitationsByRealmAndEmail", query="SELECT i FROM InvitationEntity i WHERE i.organization in (SELECT o FROM ExtOrganizationEntity o WHERE o.realmId = :realmId) AND lower(i.email) = lower(:search) ORDER BY i.createdAt"), @NamedQuery(name="getInvitationCount", query="SELECT COUNT(t) FROM InvitationEntity t WHERE t.organization = :organization")})
@Entity
@Table(name="INVITATION", uniqueConstraints={@UniqueConstraint(columnNames={"ORGANIZATION_ID", "EMAIL"})})
public class InvitationEntity {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    protected String id;
    @Email
    @Column(name="EMAIL")
    protected String email;
    @Column(name="URL")
    protected String url;
    @Column(name="INVITER_ID")
    protected String inviterId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="CREATED_AT")
    protected Date createdAt;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ORGANIZATION_ID")
    private ExtOrganizationEntity organization;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="invitation")
    protected Collection<InvitationAttributeEntity> attributes = new ArrayList<InvitationAttributeEntity>();
    @ElementCollection
    @Column(name="ROLE")
    @CollectionTable(name="INVITATION_ROLE", joinColumns={@JoinColumn(name="INVITATION_ID")})
    protected Set<String> roles = new HashSet<String>();

    @PrePersist
    protected void onCreate() {
        if (this.createdAt == null) {
            this.createdAt = new Date();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getInviterId() {
        return this.inviterId;
    }

    public void setInviterId(String inviterId) {
        this.inviterId = inviterId;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date at) {
        this.createdAt = at;
    }

    public ExtOrganizationEntity getOrganization() {
        return this.organization;
    }

    public void setOrganization(ExtOrganizationEntity organization) {
        this.organization = organization;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public Collection<InvitationAttributeEntity> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<InvitationAttributeEntity> attributes) {
        Entities.setCollection(attributes, this.attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof InvitationEntity)) {
            return false;
        }
        InvitationEntity that = (InvitationEntity)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

