/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.model.jpa.entity;

import io.phasetwo.service.model.jpa.entity.Entities;
import io.phasetwo.service.model.jpa.entity.ExtOrganizationEntity;
import io.phasetwo.service.model.jpa.entity.UserOrganizationRoleMappingEntity;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

@NamedQueries(value={@NamedQuery(name="getOrganizationRoles", query="SELECT m FROM OrganizationRoleEntity m WHERE m.organization = :organization"), @NamedQuery(name="getOrganizationRoleByName", query="SELECT m FROM OrganizationRoleEntity m WHERE m.organization = :organization AND m.name = :name"), @NamedQuery(name="removeOrganizationRole", query="DELETE FROM OrganizationRoleEntity m WHERE m.organization = :organization AND m.name = :name")})
@Table(name="ORGANIZATION_ROLE", uniqueConstraints={@UniqueConstraint(columnNames={"ORGANIZATION_ID", "NAME"})})
@Entity
public class OrganizationRoleEntity {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    protected String id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ORGANIZATION_ID")
    protected ExtOrganizationEntity organization;
    @Column(name="NAME", nullable=false)
    protected String name;
    @Column(name="DESCRIPTION")
    protected String description;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="role")
    protected Collection<UserOrganizationRoleMappingEntity> userMappings = new ArrayList<UserOrganizationRoleMappingEntity>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ExtOrganizationEntity getOrganization() {
        return this.organization;
    }

    public void setOrganization(ExtOrganizationEntity organization) {
        this.organization = organization;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Collection<UserOrganizationRoleMappingEntity> getUserMappings() {
        return this.userMappings;
    }

    public void setUserMappings(Collection<UserOrganizationRoleMappingEntity> userMappings) {
        Entities.setCollection(userMappings, this.userMappings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof OrganizationRoleEntity)) {
            return false;
        }
        OrganizationRoleEntity key = (OrganizationRoleEntity)o;
        if (!this.name.equals(key.name)) {
            return false;
        }
        return this.organization.equals(key.organization);
    }

    public int hashCode() {
        return Objects.hash(this.organization, this.name);
    }
}

