/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.protocol.oidc.mappers;

import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserInfoTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;

public abstract class AbstractOrganizationMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper,
UserInfoTokenMapper {
    private static final Logger log = Logger.getLogger(AbstractOrganizationMapper.class);
    private final String providerId;
    private final String displayType;
    private final String displayCategory;
    private final String helpText;
    private final List<ProviderConfigProperty> config;

    AbstractOrganizationMapper(String providerId, String displayType, String displayCategory, String helpText, List<ProviderConfigProperty> config) {
        this.providerId = providerId;
        this.displayType = displayType;
        this.displayCategory = displayCategory;
        this.helpText = helpText;
        this.config = config;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return this.config;
    }

    public String getId() {
        return this.providerId;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public String getDisplayCategory() {
        return this.displayCategory;
    }

    public String getHelpText() {
        return this.helpText;
    }

    protected abstract Map<String, Object> getOrganizationClaim(KeycloakSession var1, RealmModel var2, UserModel var3, ProtocolMapperModel var4);

    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession keycloakSession, ClientSessionContext clientSessionCtx) {
        log.debugf("adding org claim to idToken for %s", (Object)userSession.getUser().getUsername());
        Map<String, Object> claim = this.getOrganizationClaim(keycloakSession, userSession.getRealm(), userSession.getUser(), mappingModel);
        if (claim == null) {
            return;
        }
        OIDCAttributeMapperHelper.mapClaim((IDToken)token, (ProtocolMapperModel)mappingModel, claim);
    }

    protected void setClaim(AccessTokenResponse accessTokenResponse, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession keycloakSession, ClientSessionContext clientSessionCtx) {
        log.debugf("adding org claim to accessToken for %s", (Object)userSession.getUser().getUsername());
        UserModel user = userSession.getUser();
        Map<String, Object> claim = this.getOrganizationClaim(keycloakSession, userSession.getRealm(), userSession.getUser(), mappingModel);
        if (claim == null) {
            return;
        }
        OIDCAttributeMapperHelper.mapClaim((AccessTokenResponse)accessTokenResponse, (ProtocolMapperModel)mappingModel, claim);
    }
}

