/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.protocol.oidc.mappers;

import com.google.auto.service.AutoService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.phasetwo.service.model.OrganizationProvider;
import io.phasetwo.service.protocol.oidc.mappers.AbstractOrganizationMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.provider.ProviderConfigProperty;

@AutoService(value={ProtocolMapper.class})
public class OrganizationSpecificAttributeMapper
extends AbstractOrganizationMapper {
    private static final Logger log = Logger.getLogger(OrganizationSpecificAttributeMapper.class);
    public static final String PROVIDER_ID = "oidc-organization-specific-attribute-mapper";
    private static final List<ProviderConfigProperty> configProperties = Lists.newArrayList();

    public OrganizationSpecificAttributeMapper() {
        super(PROVIDER_ID, "Organization Specific Attribute", "Token mapper", "Map organization single specific attributes in a token claim.", configProperties);
    }

    @Override
    protected Map<String, Object> getOrganizationClaim(KeycloakSession session, RealmModel realm, UserModel user, ProtocolMapperModel mappingModel) {
        OrganizationProvider orgs = (OrganizationProvider)session.getProvider(OrganizationProvider.class);
        HashMap organizationClaim = Maps.newHashMap();
        orgs.getUserOrganizationsStream(realm, user).forEach(o -> {
            String attributeValue = o.getFirstAttribute(mappingModel.getName());
            if (attributeValue != null) {
                organizationClaim.put(o.getId(), attributeValue);
            }
        });
        log.debugf("created user %s organization claim %s", (Object)user.getUsername(), (Object)organizationClaim);
        return organizationClaim;
    }

    static {
        OIDCAttributeMapperHelper.addAttributeConfig(configProperties, OrganizationSpecificAttributeMapper.class);
    }
}

