/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.representation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jakarta.validation.Valid;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;

public class Invitation {
    @Valid
    private String id = null;
    @Valid
    private String email = null;
    @Valid
    private String createdAt = null;
    @Valid
    private String inviterId = null;
    @Valid
    private String invitationUrl = null;
    @Valid
    private String organizationId = null;
    @Valid
    private List<String> teamIds = Lists.newArrayList();
    @Valid
    private List<String> roles = Lists.newArrayList();
    @Valid
    private Map<String, List<String>> attributes = Maps.newHashMap();

    public Invitation id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Invitation email(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Invitation createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public Invitation createdAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    @JsonProperty(value="createdAt")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    @JsonIgnore
    public void setCreatedAt(Date createdAt) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        df.setTimeZone(tz);
        this.createdAt = df.format(createdAt);
    }

    public Invitation inviterId(String inviterId) {
        this.inviterId = inviterId;
        return this;
    }

    @JsonProperty(value="inviterId")
    public String getInviterId() {
        return this.inviterId;
    }

    public void setInviterId(String inviterId) {
        this.inviterId = inviterId;
    }

    public Invitation invitationUrl(String invitationUrl) {
        this.invitationUrl = invitationUrl;
        return this;
    }

    @JsonProperty(value="invitationUrl")
    public String getInvitationUrl() {
        return this.invitationUrl;
    }

    public void setInvitationUrl(String invitationUrl) {
        this.invitationUrl = invitationUrl;
    }

    public Invitation organizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    @JsonProperty(value="organizationId")
    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public Invitation teamId(String teamId) {
        if (this.teamIds == null) {
            this.teamIds = Lists.newArrayList();
        }
        if (!this.teamIds.contains(teamId)) {
            this.teamIds.add(teamId);
        }
        return this;
    }

    public Invitation teamIds(List<String> teamIds) {
        this.teamIds = teamIds;
        return this;
    }

    @JsonProperty(value="teams")
    @JsonIgnore
    public List<String> getTeamIds() {
        return this.teamIds;
    }

    public void setTeamIds(List<String> teamIds) {
        this.teamIds = teamIds;
    }

    public Invitation role(String role) {
        if (this.roles == null) {
            this.roles = Lists.newArrayList();
        }
        if (!this.roles.contains(role)) {
            this.roles.add(role);
        }
        return this;
    }

    public Invitation roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    @JsonProperty(value="roles")
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public Invitation attribute(String name, String value) {
        ArrayList list = this.attributes.get(name);
        if (list == null) {
            list = Lists.newArrayList();
        }
        if (!list.contains(value)) {
            list.add(value);
        }
        this.attributes.put(name, list);
        return this;
    }

    @JsonProperty(value="attributes")
    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invitation invitation = (Invitation)o;
        return Objects.equals(this.id, invitation.id) && Objects.equals(this.email, invitation.email) && Objects.equals(this.createdAt, invitation.createdAt) && Objects.equals(this.inviterId, invitation.inviterId) && Objects.equals(this.organizationId, invitation.organizationId) && Objects.equals(this.invitationUrl, invitation.invitationUrl) && Objects.equals(this.roles, invitation.roles) && Objects.equals(this.teamIds, invitation.teamIds) && Objects.equals(this.attributes, invitation.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.email, this.createdAt, this.inviterId, this.organizationId, this.invitationUrl, this.roles, this.attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Invitation {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    inviterId: ").append(this.toIndentedString(this.inviterId)).append("\n");
        sb.append("    organizationId: ").append(this.toIndentedString(this.organizationId)).append("\n");
        sb.append("    invitationUrl: ").append(this.toIndentedString(this.invitationUrl)).append("\n");
        sb.append("    teamIds: ").append(this.toIndentedString(this.teamIds)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

