/*
 * Decompiled with CFR 0.152.
 */
package io.phasetwo.service.representation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InvitationRequest {
    @Email
    @Valid
    private String email = null;
    @Valid
    private String inviterId = null;
    private boolean send = false;
    @Valid
    private List<String> roles = Lists.newArrayList();
    private String redirectUri = null;
    @Valid
    private Map<String, List<String>> attributes = Maps.newHashMap();

    public InvitationRequest email(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty(value="email")
    @NotNull
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public InvitationRequest inviterId(String inviterId) {
        this.inviterId = inviterId;
        return this;
    }

    @JsonProperty(value="inviterId")
    public String getInviterId() {
        return this.inviterId;
    }

    public void setInviterId(String inviterId) {
        this.inviterId = inviterId;
    }

    public InvitationRequest send(boolean send) {
        this.send = send;
        return this;
    }

    @JsonProperty(value="send")
    public boolean isSend() {
        return this.send;
    }

    public void setSend(boolean send) {
        this.send = send;
    }

    public InvitationRequest redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    @JsonProperty(value="redirectUri")
    @NotNull
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public InvitationRequest role(String role) {
        if (this.roles == null) {
            this.roles = Lists.newArrayList();
        }
        if (!this.roles.contains(role)) {
            this.roles.add(role);
        }
        return this;
    }

    public InvitationRequest roles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    @JsonProperty(value="roles")
    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public InvitationRequest attribute(String name, String value) {
        ArrayList list = this.attributes.get(name);
        if (list == null) {
            list = Lists.newArrayList();
        }
        if (!list.contains(value)) {
            list.add(value);
        }
        this.attributes.put(name, list);
        return this;
    }

    @JsonProperty(value="attributes")
    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvitationRequest invitationRequest = (InvitationRequest)o;
        return Objects.equals(this.email, invitationRequest.email) && Objects.equals(this.inviterId, invitationRequest.inviterId) && Objects.equals(this.send, invitationRequest.send) && Objects.equals(this.redirectUri, invitationRequest.redirectUri) && Objects.equals(this.roles, invitationRequest.roles) && Objects.equals(this.roles, invitationRequest.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.inviterId, this.send, this.redirectUri, this.roles, this.attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InvitationRequest {\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    inviterId: ").append(this.toIndentedString(this.inviterId)).append("\n");
        sb.append("    send: ").append(this.toIndentedString(this.send)).append("\n");
        sb.append("    redirectUri: ").append(this.toIndentedString(this.redirectUri)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

